/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.xpath.XPathConstants;
import org.apache.solr.core.Config;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrException;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.core.SolrInfoRegistry;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.StandardRequestHandler;
import org.apache.solr.util.DOMUtil;
import org.apache.solr.util.NamedList;
import org.apache.solr.util.SimpleOrderedMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RequestHandlers {
    public static Logger log = Logger.getLogger(RequestHandlers.class.getName());
    public static final String DEFAULT_HANDLER_NAME = "standard";
    private final Map<String, SolrRequestHandler> handlers = Collections.synchronizedMap(new HashMap());

    RequestHandlers() {
    }

    private static String normalize(String p) {
        if (p != null && p.endsWith("/") && p.length() > 1) {
            return p.substring(0, p.length() - 1);
        }
        return p;
    }

    public SolrRequestHandler get(String handlerName) {
        return this.handlers.get(RequestHandlers.normalize(handlerName));
    }

    public SolrRequestHandler register(String handlerName, SolrRequestHandler handler) {
        String norm = RequestHandlers.normalize(handlerName);
        if (handler == null) {
            return this.handlers.remove(norm);
        }
        SolrRequestHandler old = this.handlers.put(norm, handler);
        if (handlerName != null && handlerName != "" && handler instanceof SolrInfoMBean) {
            SolrInfoRegistry.getRegistry().put(handlerName, (SolrInfoMBean)handler);
        }
        return old;
    }

    public Map<String, SolrRequestHandler> getRequestHandlers() {
        return Collections.unmodifiableMap(this.handlers);
    }

    void initHandlersFromConfig(Config config) {
        SolrRequestHandler handler;
        NodeList nodes = (NodeList)config.evaluate("requestHandler", XPathConstants.NODESET);
        if (nodes != null) {
            LinkedHashMap<String, NamedList> names = new LinkedHashMap<String, NamedList>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                try {
                    String name = DOMUtil.getAttr(node, "name", "requestHandler config");
                    String className = DOMUtil.getAttr(node, "class", "requestHandler config");
                    String startup = DOMUtil.getAttr(node, "startup", null);
                    NamedList args = DOMUtil.childNodesToNamedList(node);
                    LazyRequestHandlerWrapper handler2 = null;
                    if ("lazy".equals(startup)) {
                        log.info("adding lazy requestHandler: " + name + "=" + className);
                        handler2 = new LazyRequestHandlerWrapper(className, args);
                    } else {
                        Class clazz = Config.findClass(className, new String[0]);
                        log.info("adding requestHandler: " + name + "=" + className);
                        handler2 = (SolrRequestHandler)clazz.newInstance();
                    }
                    SolrRequestHandler old = this.register(name, handler2);
                    if (old != null) {
                        String msg = "multiple handlers registered on the same path! ignoring: " + old;
                        SolrException t = new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                        SolrConfig.severeErrors.add(t);
                        SolrException.logOnce(log, null, t);
                    }
                    names.put(name, args);
                    continue;
                }
                catch (Exception e) {
                    SolrConfig.severeErrors.add(e);
                    SolrException.logOnce(log, null, e);
                }
            }
            for (Map.Entry reg : names.entrySet()) {
                try {
                    this.handlers.get(reg.getKey()).init((NamedList)reg.getValue());
                }
                catch (Exception e) {
                    SolrConfig.severeErrors.add(e);
                    SolrException.logOnce(log, null, e);
                }
            }
        }
        if ((handler = this.get(DEFAULT_HANDLER_NAME)) == null) {
            handler = new StandardRequestHandler();
            this.register(DEFAULT_HANDLER_NAME, handler);
        }
        this.register(null, handler);
        this.register("", handler);
    }

    private static final class LazyRequestHandlerWrapper
    implements SolrRequestHandler,
    SolrInfoMBean {
        private String _className;
        private NamedList _args;
        private SolrRequestHandler _handler;

        public LazyRequestHandlerWrapper(String className, NamedList args) {
            this._className = className;
            this._args = args;
            this._handler = null;
        }

        public void init(NamedList args) {
        }

        public void handleRequest(SolrQueryRequest req, SolrQueryResponse rsp) {
            this.getWrappedHandler().handleRequest(req, rsp);
        }

        public synchronized SolrRequestHandler getWrappedHandler() {
            if (this._handler == null) {
                try {
                    Class clazz = Config.findClass(this._className, new String[0]);
                    this._handler = (SolrRequestHandler)clazz.newInstance();
                    this._handler.init(this._args);
                }
                catch (Exception ex) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "lazy loading error", (Throwable)ex);
                }
            }
            return this._handler;
        }

        public String getHandlerClass() {
            return this._className;
        }

        public String getName() {
            return "Lazy[" + this._className + "]";
        }

        public String getDescription() {
            if (this._handler == null) {
                return this.getName();
            }
            return this._handler.getDescription();
        }

        public String getVersion() {
            String rev = "$Revision: 542679 $";
            if (this._handler != null) {
                rev = rev + " :: " + this._handler.getVersion();
            }
            return rev;
        }

        public String getSourceId() {
            String rev = "$Id: RequestHandlers.java 542679 2007-05-29 22:28:21Z ryan $";
            if (this._handler != null) {
                rev = rev + " :: " + this._handler.getSourceId();
            }
            return rev;
        }

        public String getSource() {
            String rev = "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.2/src/java/org/apache/solr/core/RequestHandlers.java $";
            if (this._handler != null) {
                rev = rev + "\n" + this._handler.getSource();
            }
            return rev;
        }

        public URL[] getDocs() {
            if (this._handler == null) {
                return null;
            }
            return this._handler.getDocs();
        }

        public SolrInfoMBean.Category getCategory() {
            return SolrInfoMBean.Category.QUERYHANDLER;
        }

        public NamedList getStatistics() {
            if (this._handler != null) {
                return this._handler.getStatistics();
            }
            SimpleOrderedMap<String> lst = new SimpleOrderedMap<String>();
            lst.add("note", "not initaized yet");
            return lst;
        }
    }
}

