/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.repackage.cglib.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hibernate.repackage.cglib.core.AbstractClassGenerator;
import org.hibernate.repackage.cglib.core.CodeGenerationException;
import org.hibernate.repackage.cglib.core.Signature;
import org.hibernate.repackage.cglib.proxy.MethodInterceptorGenerator;
import org.hibernate.repackage.cglib.reflect.FastClass;

public class MethodProxy {
    private Signature sig;
    private String superName;
    private FastClass f1;
    private FastClass f2;
    private int i1;
    private int i2;

    public static MethodProxy create(ClassLoader loader, Class c1, Class c2, String desc, String name1, String name2) {
        final Signature sig1 = new Signature(name1, desc);
        Signature sig2 = new Signature(name2, desc);
        FastClass f1 = MethodProxy.helper(loader, c1);
        FastClass f2 = MethodProxy.helper(loader, c2);
        int i1 = f1.getIndex(sig1);
        int i2 = f2.getIndex(sig2);
        MethodProxy proxy = i1 < 0 ? new MethodProxy(){

            public Object invoke(Object obj, Object[] args) throws Throwable {
                throw new IllegalArgumentException("Protected method: " + sig1);
            }
        } : new MethodProxy();
        proxy.f1 = f1;
        proxy.f2 = f2;
        proxy.i1 = i1;
        proxy.i2 = i2;
        proxy.sig = sig1;
        proxy.superName = name2;
        return proxy;
    }

    private static FastClass helper(ClassLoader loader, Class type) {
        FastClass.Generator g = new FastClass.Generator();
        g.setType(type);
        g.setClassLoader(loader);
        AbstractClassGenerator fromEnhancer = AbstractClassGenerator.getCurrent();
        if (fromEnhancer != null) {
            g.setNamingPolicy(fromEnhancer.getNamingPolicy());
            g.setStrategy(fromEnhancer.getStrategy());
            g.setAttemptLoad(fromEnhancer.getAttemptLoad());
        }
        return g.create();
    }

    private MethodProxy() {
    }

    public Signature getSignature() {
        return this.sig;
    }

    public String getSuperName() {
        return this.superName;
    }

    public int getSuperIndex() {
        return this.i2;
    }

    public static MethodProxy find(Class type, Signature sig) {
        try {
            Method m = type.getDeclaredMethod("CGLIB$findMethodProxy", MethodInterceptorGenerator.FIND_PROXY_TYPES);
            return (MethodProxy)m.invoke(null, sig);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + type + " does not use a MethodInterceptor");
        }
        catch (IllegalAccessException e) {
            throw new CodeGenerationException(e);
        }
        catch (InvocationTargetException e) {
            throw new CodeGenerationException(e);
        }
    }

    public Object invoke(Object obj, Object[] args) throws Throwable {
        try {
            return this.f1.invoke(this.i1, obj, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public Object invokeSuper(Object obj, Object[] args) throws Throwable {
        try {
            return this.f2.invoke(this.i2, obj, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

