/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelContext;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public class RegistryBean
implements BeanHolder {
    private final CamelContext context;
    private final String name;
    private final Registry registry;
    private Processor processor;
    private BeanInfo beanInfo;
    private Object bean;
    private ParameterMappingStrategy parameterMappingStrategy;

    public RegistryBean(CamelContext context, String name) {
        this.context = context;
        this.name = name;
        this.registry = context.getRegistry();
    }

    public String toString() {
        return "bean: " + this.name;
    }

    public ConstantBeanHolder createCacheHolder() throws Exception {
        return new ConstantBeanHolder(this.getBean(), this.getBeanInfo());
    }

    public Object getBean() throws NoSuchBeanException {
        Class<?> value = this.lookupBean();
        if (value == null && (value = this.context.getClassResolver().resolveClass(this.name)) == null) {
            throw new NoSuchBeanException(this.name);
        }
        if (value != this.bean) {
            this.bean = value;
            this.processor = null;
            if (!ObjectHelper.equal(ObjectHelper.type(this.bean), ObjectHelper.type(value))) {
                this.beanInfo = null;
            }
            if (this.bean instanceof Class) {
                value = this.bean = this.context.getInjector().newInstance((Class)this.bean);
            }
        }
        return value;
    }

    public Processor getProcessor() {
        if (this.processor == null && this.bean != null) {
            this.processor = CamelContextHelper.convertTo(this.context, Processor.class, this.bean);
        }
        return this.processor;
    }

    public BeanInfo getBeanInfo() {
        if (this.beanInfo == null && this.bean != null) {
            this.beanInfo = this.createBeanInfo();
        }
        return this.beanInfo;
    }

    public String getName() {
        return this.name;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public CamelContext getContext() {
        return this.context;
    }

    public ParameterMappingStrategy getParameterMappingStrategy() {
        if (this.parameterMappingStrategy == null) {
            this.parameterMappingStrategy = this.createParameterMappingStrategy();
        }
        return this.parameterMappingStrategy;
    }

    public void setParameterMappingStrategy(ParameterMappingStrategy parameterMappingStrategy) {
        this.parameterMappingStrategy = parameterMappingStrategy;
    }

    protected BeanInfo createBeanInfo() {
        return new BeanInfo(this.context, this.bean.getClass(), this.getParameterMappingStrategy());
    }

    protected ParameterMappingStrategy createParameterMappingStrategy() {
        return BeanInfo.createParameterMappingStrategy(this.context);
    }

    protected Object lookupBean() {
        return this.registry.lookup(this.name);
    }
}

