/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.ByteArrayOutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.processor.Traceable;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ObjectHelper;

public class MarshalProcessor
implements Processor,
Traceable {
    private final DataFormat dataFormat;

    public MarshalProcessor(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void process(Exchange exchange) throws Exception {
        ObjectHelper.notNull(this.dataFormat, "dataFormat");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Message in = exchange.getIn();
        Object body = in.getBody();
        Message out = exchange.getOut();
        out.copyFrom(in);
        this.dataFormat.marshal(exchange, body, buffer);
        byte[] data = buffer.toByteArray();
        out.setBody(data);
    }

    public String toString() {
        return "Marshal[" + this.dataFormat + "]";
    }

    public String getTraceLabel() {
        return "marshal[" + this.dataFormat + "]";
    }
}

