/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class SendAsyncProcessor
extends SendProcessor
implements Runnable,
Navigate<Processor> {
    private final CamelContext camelContext;
    private final Processor target;
    private final BlockingQueue<Exchange> completedTasks = new LinkedBlockingQueue<Exchange>();
    private ExecutorService executorService;
    private ExecutorService producerExecutorService;
    private int poolSize = 10;
    private ExceptionHandler exceptionHandler;

    public SendAsyncProcessor(Endpoint destination, Processor target) {
        super(destination);
        this.target = target;
        this.camelContext = destination.getCamelContext();
    }

    public SendAsyncProcessor(Endpoint destination, ExchangePattern pattern, Processor target) {
        super(destination, pattern);
        this.target = target;
        this.camelContext = destination.getCamelContext();
    }

    @Override
    protected Exchange configureExchange(Exchange exchange, ExchangePattern pattern) {
        Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, true);
        if (pattern != null) {
            copy.setPattern(pattern);
        } else {
            copy.setPattern(ExchangePattern.InOut);
        }
        copy.setProperty("CamelToEndpoint", this.destination.getEndpointUri());
        return copy;
    }

    @Override
    public Exchange doProcess(Exchange exchange) throws Exception {
        final Producer producer = this.producerCache.acquireProducer(this.destination);
        ObjectHelper.notNull(producer, "producer");
        AsyncCallback callback = new AsyncCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTaskCompleted(Exchange exchange) {
                if (SendProcessor.LOG.isTraceEnabled()) {
                    SendProcessor.LOG.trace((Object)("onTaskCompleted " + exchange));
                }
                try {
                    SendAsyncProcessor.this.completedTasks.add(exchange);
                }
                finally {
                    try {
                        SendAsyncProcessor.this.producerCache.releaseProducer(SendAsyncProcessor.this.destination, producer);
                    }
                    catch (Exception e) {
                        SendProcessor.LOG.warn((Object)("Error releasing producer: " + producer + ". This exception will be ignored."), (Throwable)e);
                    }
                }
            }
        };
        exchange = this.configureExchange(exchange, this.pattern);
        if (producer instanceof AsyncProcessor) {
            this.doAsyncProcess((AsyncProcessor)((Object)producer), exchange, callback);
        } else {
            this.doSimulateAsyncProcess(producer, exchange, callback);
        }
        return exchange;
    }

    protected void doAsyncProcess(AsyncProcessor producer, Exchange exchange, AsyncCallback callback) throws Exception {
        producer.process(exchange, callback);
    }

    protected void doSimulateAsyncProcess(final Processor producer, final Exchange exchange, final AsyncCallback callback) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Producer " + producer + " is not an instanceof AsyncProcessor" + ". Will fallback to simulate async behavior by transferring task to a producer thread pool for further processing."));
        }
        this.getProducerExecutorService().submit(new Callable<Exchange>(){

            @Override
            public Exchange call() throws Exception {
                try {
                    AsyncProcessor asyncProducer = exchange.getContext().getTypeConverter().convertTo(AsyncProcessor.class, producer);
                    asyncProducer.process(exchange, callback);
                }
                catch (Exception e) {
                    if (SendProcessor.LOG.isDebugEnabled()) {
                        SendProcessor.LOG.debug((Object)("Caught exception while processing: " + exchange), (Throwable)e);
                    }
                    exchange.setException(e);
                }
                return exchange;
            }
        });
    }

    @Override
    public String toString() {
        return "sendAsyncTo(" + this.destination + (this.pattern != null ? " " + (Object)((Object)this.pattern) : "") + " -> " + this.target + ")";
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public synchronized ExecutorService getProducerExecutorService() {
        if (this.producerExecutorService == null) {
            this.producerExecutorService = this.destination.getCamelContext().getExecutorServiceStrategy().newDefaultThreadPool(this, "SendAsyncProcessor-Producer");
        }
        return this.producerExecutorService;
    }

    public void setProducerExecutorService(ExecutorService producerExecutorService) {
        this.producerExecutorService = producerExecutorService;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(this.getClass());
        }
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public boolean hasNext() {
        return this.target != null;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.target);
        return answer;
    }

    @Override
    public void run() {
        while (this.isRunAllowed()) {
            Exchange exchange;
            try {
                exchange = this.completedTasks.poll(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Sleep interrupted, are we stopping? " + (this.isStopping() || this.isStopped())));
                continue;
            }
            if (exchange == null) continue;
            try {
                if (exchange.hasOut()) {
                    exchange.setIn(exchange.getOut());
                    exchange.setOut(null);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Async reply received now routing the Exchange: " + exchange));
                }
                this.target.process(exchange);
            }
            catch (Throwable e) {
                this.getExceptionHandler().handleException(e);
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.poolSize <= 0) {
            throw new IllegalArgumentException("PoolSize must be a positive number, was: " + this.poolSize);
        }
        for (int i = 0; i < this.poolSize; ++i) {
            if (this.executorService == null) {
                this.executorService = this.destination.getCamelContext().getExecutorServiceStrategy().newFixedThreadPool(this, "SendAsyncProcessor-Consumer", this.poolSize);
            }
            this.executorService.execute(this);
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.executorService != null) {
            this.camelContext.getExecutorServiceStrategy().shutdownNow(this.executorService);
            this.executorService = null;
        }
    }

    @Override
    protected void doShutdown() throws Exception {
        super.doShutdown();
        this.completedTasks.clear();
    }
}

