/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.resourcegen;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.xml.bind.api.impl.NameConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class ResourceGenTask
extends Task {
    private FileSet resources;
    private File destDir;

    public void addConfiguredResource(FileSet fs) {
        this.resources = fs;
    }

    public void setDestDir(File dir) {
        this.destDir = dir;
    }

    public void execute() throws BuildException {
        if (this.resources == null) {
            throw new BuildException("No resource file is specified");
        }
        if (this.destDir == null) {
            throw new BuildException("No destdir attribute is specified");
        }
        this.destDir.mkdirs();
        JCodeModel cm = new JCodeModel();
        DirectoryScanner ds = this.resources.getDirectoryScanner(this.getProject());
        String[] includedFiles = ds.getIncludedFiles();
        File baseDir = ds.getBasedir();
        for (String value : includedFiles) {
            JClass lable_class;
            JClass l_class;
            JClass lmf_class;
            JDefinedClass clazz;
            File res = new File(baseDir, value);
            if (res.getName().contains("_")) continue;
            String className = this.getClassName(res);
            String bundleName = value.substring(0, value.lastIndexOf(46)).replace('/', '.').replace('\\', '.');
            String dirName = bundleName.substring(0, bundleName.lastIndexOf(46));
            File destFile = new File(new File(this.destDir, dirName.replace('.', '/')), className + ".java");
            if (destFile.lastModified() >= res.lastModified()) {
                this.log("Skipping " + res, 2);
                continue;
            }
            this.log("Processing " + res, 2);
            JPackage pkg = cm._package(dirName);
            Properties props = new Properties();
            try {
                FileInputStream in = new FileInputStream(res);
                props.load(in);
                in.close();
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            try {
                clazz = pkg._class(9, className);
            }
            catch (JClassAlreadyExistsException e) {
                throw new BuildException("Name conflict " + className);
            }
            clazz.javadoc().add((Object)"Defines string formatting method for each constant in the resource file");
            try {
                lmf_class = cm.parseType("com.sun.xml.ws.util.localization.LocalizableMessageFactory").boxify();
                l_class = cm.parseType("com.sun.xml.ws.util.localization.Localizer").boxify();
                lable_class = cm.parseType("com.sun.xml.ws.util.localization.Localizable").boxify();
            }
            catch (ClassNotFoundException e) {
                throw new BuildException((Throwable)e);
            }
            JFieldVar $msgFactory = clazz.field(28, (JType)lmf_class, "messageFactory", (JExpression)JExpr._new((JClass)lmf_class).arg(JExpr.lit((String)bundleName)));
            JFieldVar $localizer = clazz.field(28, (JType)l_class, "localizer", (JExpression)JExpr._new((JClass)l_class));
            for (Object key : props.keySet()) {
                String methodBaseName = NameConverter.smart.toConstantName(key.toString());
                JMethod method = clazz.method(17, (JType)lable_class, "localizable" + methodBaseName);
                int countArgs = this.countArgs(props.getProperty(key.toString()));
                JInvocation format = $msgFactory.invoke("getMessage").arg(JExpr.lit((String)key.toString()));
                for (int i = 0; i < countArgs; ++i) {
                    format.arg((JExpression)method.param(Object.class, "arg" + i));
                }
                method.body()._return((JExpression)format);
                JMethod method2 = clazz.method(17, String.class, methodBaseName);
                method2.javadoc().add(props.get(key));
                JInvocation localize = JExpr.invoke((JMethod)method);
                for (int i = 0; i < countArgs; ++i) {
                    localize.arg((JExpression)method2.param(Object.class, "arg" + i));
                }
                method2.body()._return((JExpression)$localizer.invoke("localize").arg((JExpression)localize));
            }
        }
        try {
            cm.build(this.destDir);
        }
        catch (IOException e) {
            throw new BuildException("Failed to generate code", (Throwable)e);
        }
    }

    private int countArgs(String value) {
        String r2;
        String r1;
        ArrayList<String> x = new ArrayList<String>();
        do {
            r1 = MessageFormat.format(value, x.toArray());
            x.add("xxxx");
        } while (!r1.equals(r2 = MessageFormat.format(value, x.toArray())));
        return x.size() - 1;
    }

    private String getClassName(File res) {
        String name = res.getName();
        int suffixIndex = name.lastIndexOf(46);
        name = name.substring(0, suffixIndex);
        return NameConverter.smart.toClassName(name) + "Messages";
    }
}

