/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.joram.mom.dest.collector;

import com.scalagent.joram.mom.dest.collector.Collector;
import com.scalagent.joram.mom.dest.collector.CollectorDestination;
import com.scalagent.joram.mom.dest.collector.CollectorHelper;
import com.scalagent.joram.mom.dest.collector.CollectorQueueImplMBean;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Debug;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.shared.messages.ConversionHelper;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class CollectorQueueImpl
extends QueueImpl
implements CollectorDestination,
CollectorQueueImplMBean {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger(CollectorQueueImpl.class.getName());
    private Collector collector;
    private long messageExpiration = 0L;
    private boolean messagePersistent = false;
    private long count = 0L;
    private boolean isPersistent = false;
    private int priority = 4;
    private long expiration = -1L;

    public boolean isMessagePersistent() {
        return this.isPersistent;
    }

    public void setMessagePersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public CollectorQueueImpl(AgentId adminId, Properties properties) {
        super(adminId, properties);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("CollectorQueueImpl.<init> prop = " + properties));
        }
        if (properties != null) {
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                try {
                    if (name.equals("period")) continue;
                    if (name.equals("persistent")) {
                        this.isPersistent = ConversionHelper.toBoolean(properties.get("persistent"));
                        continue;
                    }
                    if (name.equals("priority")) {
                        this.priority = ConversionHelper.toInt(properties.get("priority"));
                        continue;
                    }
                    if (name.equals("expiration")) {
                        this.expiration = ConversionHelper.toLong(properties.get("expiration"));
                        continue;
                    }
                    if (!name.equals("collector.className")) continue;
                    String className = ConversionHelper.toString(properties.get("collector.className"));
                    if (className == null) {
                        className = "com.scalagent.joram.mom.dest.collector.URLCollector";
                    }
                    this.createCollector(className, properties);
                }
                catch (Exception exc) {
                    logger.log(BasicLevel.ERROR, (Object)"CollectorQueueImpl.<init>: bad initialization.", (Throwable)exc);
                }
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("CollectorQueueImpl.<init> period = " + this.getPeriod() + ", collector = " + this.collector));
            }
        }
    }

    private void createCollector(String className, Properties properties) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName(className);
        this.collector = (Collector)clazz.newInstance();
        this.collector.setCollectorDestination(this);
        this.collector.setProperties(properties);
    }

    private Properties transform(org.objectweb.joram.shared.util.Properties properties) {
        if (properties == null) {
            return null;
        }
        Properties prop = new Properties();
        Enumeration e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            prop.put(key, properties.get(key));
        }
        return prop;
    }

    public void initialize(boolean firstTime) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("CollectorQueueImpl.initialize(" + firstTime + ')'));
        }
        super.initialize(firstTime);
        if (firstTime) {
            try {
                if (this.collector != null) {
                    this.collector.check();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void wakeUpNot(WakeUpNot not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"CollectorQueueImpl.collectorWakeUp()");
        }
        super.wakeUpNot(not);
        try {
            this.collector.check();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ClientMessages preProcess(AgentId from, ClientMessages cm) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Change collector properties. preProcess(" + from + ", " + cm + ')'));
        }
        long period = this.getPeriod();
        Vector msgs = cm.getMessages();
        for (int i = 0; i < msgs.size(); ++i) {
            Message msg = (Message)msgs.elementAt(i);
            if (msg.properties != null) {
                Enumeration enumProperties = msg.properties.keys();
                while (enumProperties.hasMoreElements()) {
                    String key = (String)enumProperties.nextElement();
                    try {
                        if (key.equals("period")) {
                            period = ConversionHelper.toLong(msg.properties.get("period"));
                            continue;
                        }
                        if (key.equals("persistent")) {
                            this.isPersistent = ConversionHelper.toBoolean(msg.properties.get("persistent"));
                            continue;
                        }
                        if (key.equals("priority")) {
                            this.priority = ConversionHelper.toInt(msg.properties.get("priority"));
                            continue;
                        }
                        if (key.equals("expiration")) {
                            this.expiration = ConversionHelper.toLong(msg.properties.get("expiration"));
                            continue;
                        }
                        if (!key.equals("collector.className")) continue;
                        String className = ConversionHelper.toString(msg.properties.get("collector.className"));
                        if (className == null) {
                            className = "com.scalagent.joram.mom.dest.collector.URLCollector";
                        }
                        this.createCollector(className, this.transform(msg.properties));
                    }
                    catch (Exception exc) {
                        logger.log(BasicLevel.ERROR, (Object)"CollectorQueueImpl.<init>: bad configuration.", (Throwable)exc);
                    }
                }
            }
            msg.properties = null;
        }
        this.setPeriod(period);
        return null;
    }

    public void sendMessage(int type, byte[] body, org.objectweb.joram.shared.util.Properties properties) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("CollectorQueueImpl.sendMessage(" + type + ", " + body + ", " + properties + ')'));
        }
        Message msg = CollectorHelper.createMessage(type, body, properties, this.messageExpiration, this.messagePersistent, "collectorQueue_" + this.count);
        ++this.count;
        ClientMessages clientMsgs = CollectorHelper.createClientMessages(msg);
        this.addClientMessages(clientMsgs);
    }

    public String toString() {
        return "CollectorQueueImpl:" + this.getId().toString();
    }
}

