/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.MessageConsumer;
import fr.dyade.aaa.agent.ServiceDesc;
import fr.dyade.aaa.common.SocketAddress;
import fr.dyade.aaa.common.Strings;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;

public final class ServerDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    short sid;
    String name;
    private Vector sockAddrs = null;
    transient ServiceDesc[] services = null;
    short gateway = (short)-1;
    private transient MessageConsumer domain = null;
    volatile transient boolean active = true;
    volatile transient long last = 0L;
    volatile transient int retry = 0;

    public ServerDesc(short sid, String name, String hostname, int port) {
        this.sid = sid;
        this.name = name;
        this.sockAddrs = new Vector();
        this.sockAddrs.addElement(new SocketAddress(hostname, port));
    }

    public short getServerId() {
        return this.sid;
    }

    public String getServerName() {
        return this.name;
    }

    public String getHostname() {
        return ((SocketAddress)this.sockAddrs.firstElement()).getHostname();
    }

    public int getPort() {
        return ((SocketAddress)this.sockAddrs.firstElement()).getPort();
    }

    public InetAddress getAddr() {
        return ((SocketAddress)this.sockAddrs.firstElement()).getAddress();
    }

    public InetAddress resetAddr() {
        ((SocketAddress)this.sockAddrs.firstElement()).resetAddr();
        return this.getAddr();
    }

    void addSockAddr(String hostname, int port) {
        this.sockAddrs.addElement(new SocketAddress(hostname, port));
    }

    public void updateSockAddr(String hostname, int port) {
        this.sockAddrs.remove(0);
        this.sockAddrs.insertElementAt(new SocketAddress(hostname, port), 0);
    }

    void moveToFirst(SocketAddress addr) {
        if (this.sockAddrs.indexOf(addr) > 0 && this.sockAddrs.remove(addr)) {
            this.sockAddrs.insertElementAt(addr, 0);
        }
    }

    Enumeration getSockAddrs() {
        return this.sockAddrs.elements();
    }

    public ServiceDesc[] getServices() {
        return this.services;
    }

    public short getGateway() {
        return this.gateway;
    }

    public void setGateway(short id) {
        this.gateway = id;
    }

    public String getDomainName() {
        return this.domain.getDomainName();
    }

    public Class getDomainType() {
        return this.domain.getClass();
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("(").append(super.toString());
        strBuf.append(",sid=").append(this.sid);
        strBuf.append(",name=").append(this.name);
        strBuf.append(",services=");
        Strings.toString(strBuf, this.services);
        strBuf.append(",active=").append(this.active);
        strBuf.append(",last=").append(this.last);
        strBuf.append(",gateway=").append(this.gateway);
        strBuf.append(",sockAddrs=").append(this.sockAddrs);
        strBuf.append(",domain=").append(this.domain);
        strBuf.append(")");
        return strBuf.toString();
    }

    public void setDomain(MessageConsumer domain) {
        this.domain = domain;
    }

    public MessageConsumer getDomain() {
        return this.domain;
    }
}

