/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent.osgi;

import fr.dyade.aaa.agent.AdminProxy;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.Service;
import java.util.Dictionary;
import java.util.Properties;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    public static final Logger logmon = Debug.getLogger(Activator.class.getName());
    public static final String AGENT_SERVER_ID_PROPERTY = "fr.dyade.aaa.agent.AgentServer.id";
    public static final String AGENT_SERVER_CLUSTERID_PROPERTY = "fr.dyade.aaa.agent.AgentServer.clusterid";
    public static final String AGENT_SERVER_STORAGE_PROPERTY = "fr.dyade.aaa.agent.AgentServer.storage";
    public static BundleContext context;
    private ServiceRegistration adminproxyRegistration;

    public static void stopFramework() {
        block3: {
            if (context.getBundle().getState() != 16) {
                try {
                    Bundle bundle = context.getBundle(0L);
                    bundle.stop();
                }
                catch (BundleException exc) {
                    if (!logmon.isLoggable(BasicLevel.ERROR)) break block3;
                    logmon.log(BasicLevel.ERROR, (Object)"Error when stopping OSGi framework : ", (Throwable)exc);
                }
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        Activator.context = context;
        AgentServer.isOSGi = true;
        short sid = this.getShortProperty(AGENT_SERVER_ID_PROPERTY, (short)0);
        String path = this.getProperty(AGENT_SERVER_STORAGE_PROPERTY, "s" + sid);
        short cid = this.getShortProperty(AGENT_SERVER_CLUSTERID_PROPERTY, (short)-1);
        Properties props = new Properties();
        props.put("A3ServiceClass", AdminProxy.class.getName());
        this.adminproxyRegistration = context.registerService(Service.class.getName(), (Object)new Service(), (Dictionary)props);
        try {
            AgentServer.init(sid, path, null, cid);
            AgentServer.start();
        }
        catch (RuntimeException exc) {
            logmon.log(BasicLevel.ERROR, (Object)"Error when starting AgentServer: ", (Throwable)exc);
        }
    }

    public void stop(BundleContext context) throws Exception {
        AgentServer.stop();
        AgentServer.reset();
        this.adminproxyRegistration.unregister();
        Activator.context = null;
    }

    private short getShortProperty(String propName, short defaultValue) {
        String propValue = context.getProperty(propName);
        if (propValue != null) {
            return Short.parseShort(propValue);
        }
        return defaultValue;
    }

    private String getProperty(String propName, String defaultValue) {
        String propValue = context.getProperty(propName);
        if (propValue != null) {
            return propValue;
        }
        return defaultValue;
    }
}

