/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.objectweb.joram.mom.dest.MonitoringElement;
import org.objectweb.joram.mom.dest.MonitoringHelper;
import org.objectweb.joram.mom.dest.MonitoringTopicImplMBean;
import org.objectweb.joram.mom.dest.TopicImpl;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.shared.messages.ConversionHelper;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;

public class MonitoringTopicImpl
extends TopicImpl
implements MonitoringTopicImplMBean {
    private static final long serialVersionUID = 1L;
    private long msgCounter = 0L;
    private Vector elements = new Vector();
    private boolean isPersistent = false;
    private int priority = 4;
    private long expiration = -1L;

    public boolean isMessagePersistent() {
        return this.isPersistent;
    }

    public void setMessagePersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public MonitoringTopicImpl(AgentId adminId, Properties properties) {
        super(adminId, properties);
        if (properties != null) {
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                try {
                    if (name.equals("period")) continue;
                    if (name.equals("persistent")) {
                        this.isPersistent = ConversionHelper.toBoolean(properties.get("persistent"));
                        continue;
                    }
                    if (name.equals("priority")) {
                        this.priority = ConversionHelper.toInt(properties.get("priority"));
                        continue;
                    }
                    if (name.equals("expiration")) {
                        this.expiration = ConversionHelper.toLong(properties.get("expiration"));
                        continue;
                    }
                    String attributes = (String)properties.get(name);
                    this.elements.add(new MonitoringElement(name, attributes));
                }
                catch (Exception exc) {
                    logger.log(BasicLevel.ERROR, (Object)"MonitoringTopicImpl.<init>: bad initialization.", (Throwable)exc);
                }
            }
        }
    }

    public void initialize(boolean firstTime) {
        super.initialize(firstTime);
    }

    public ClientMessages preProcess(AgentId from, ClientMessages cm) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("MonitoringQueueImpl. preProcess(" + from + ", " + cm + ')'));
        }
        long period = this.getPeriod();
        Vector msgs = cm.getMessages();
        for (int i = 0; i < msgs.size(); ++i) {
            Message msg = (Message)msgs.elementAt(i);
            if (msg.properties == null) continue;
            this.elements.clear();
            Enumeration e = msg.properties.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                try {
                    if (name.equals("period")) {
                        period = ConversionHelper.toLong(msg.properties.get("period"));
                        continue;
                    }
                    if (name.equals("persistent")) {
                        this.isPersistent = ConversionHelper.toBoolean(msg.properties.get("persistent"));
                        continue;
                    }
                    if (name.equals("priority")) {
                        this.priority = ConversionHelper.toInt(msg.properties.get("priority"));
                        continue;
                    }
                    if (name.equals("expiration")) {
                        this.expiration = ConversionHelper.toLong(msg.properties.get("expiration"));
                        continue;
                    }
                    String attributes = (String)msg.properties.get(name);
                    this.elements.add(new MonitoringElement(name, attributes));
                }
                catch (Exception exc) {
                    logger.log(BasicLevel.ERROR, (Object)"MonitoringTopicImpl.<init>: bad configuration.", (Throwable)exc);
                }
            }
            msg.properties = null;
            MonitoringHelper.getJMXValues(msg, this.elements);
        }
        this.setPeriod(period);
        return cm;
    }

    private String createMessageId() {
        ++this.msgCounter;
        return "ID:" + this.getId().toString() + '_' + this.msgCounter;
    }

    public void wakeUpNot(WakeUpNot not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " MonitoringTopicImpl.wakeUpNot(" + not + ")"));
        }
        long currentTime = System.currentTimeMillis();
        Message message = new Message();
        message.id = this.createMessageId();
        message.timestamp = currentTime;
        message.persistent = this.isPersistent;
        message.setDestination(this.getId().toString(), (byte)1);
        message.priority = this.priority;
        message.expiration = this.expiration > 0L ? currentTime + this.expiration : 0L;
        MonitoringHelper.getJMXValues(message, this.elements);
        ClientMessages clientMessages = new ClientMessages(-1, -1, message);
        this.forwardMessages(clientMessages);
        this.processMessages(clientMessages);
    }

    public String[] getMonitoredAttributes() {
        return MonitoringHelper.getMonitoredAttributes(this.elements);
    }

    public void addMonitoredAttributes(String MBeanName, String attributes) {
        MonitoringHelper.addMonitoredAttributes(this.elements, MBeanName, attributes);
    }

    public void delMonitoredAttributes(String mbean) {
        MonitoringHelper.delMonitoredAttributes(this.elements, mbean);
    }
}

