/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.requestor;

import java.util.HashMap;
import java.util.Map;

public class MessageSelectorProvider {
    protected Map<String, String> correlationIds = new HashMap<String, String>();
    protected boolean dirty = true;
    protected StringBuilder expression;

    public synchronized void addCorrelationID(String id) {
        this.correlationIds.put(id, id);
        this.dirty = true;
    }

    public synchronized void removeCorrelationID(String id) {
        this.correlationIds.remove(id);
        this.dirty = true;
    }

    public synchronized String get() {
        if (!this.dirty) {
            return this.expression.toString();
        }
        this.expression = new StringBuilder("JMSCorrelationID='");
        boolean first = true;
        for (Map.Entry<String, String> entry : this.correlationIds.entrySet()) {
            if (!first) {
                this.expression.append(" OR JMSCorrelationID='");
            }
            this.expression.append(entry.getValue()).append("'");
            if (!first) continue;
            first = false;
        }
        this.dirty = false;
        return this.expression.toString();
    }
}

