/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.meta;

import java.io.IOException;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.meta.MetaDataFilter;
import org.apache.openjpa.lib.util.Localizer;
import serp.bytecode.lowlevel.ConstantPoolTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassAnnotationMetaDataFilter
implements MetaDataFilter {
    private final String[] _annos;
    private static final Localizer _loc = Localizer.forPackage(ClassAnnotationMetaDataFilter.class);
    private Log _log = null;

    public ClassAnnotationMetaDataFilter(Class<?> anno) {
        this(new Class[]{anno});
    }

    public ClassAnnotationMetaDataFilter(Class<?>[] annos) {
        this._annos = new String[annos.length];
        for (int i = 0; i < annos.length; ++i) {
            this._annos[i] = "L" + annos[i].getName().replace('.', '/') + ";";
        }
    }

    @Override
    public boolean matches(MetaDataFilter.Resource rsrc) throws IOException {
        block7: {
            if (this._annos.length == 0 || !rsrc.getName().endsWith(".class")) {
                return false;
            }
            try {
                ConstantPoolTable table = new ConstantPoolTable(rsrc.getContent());
                int idx = table.getEndIndex();
                int interfaces = table.readUnsignedShort(idx += 6);
                int fields = table.readUnsignedShort(idx += 2 + interfaces * 2);
                idx += 2;
                for (int i = 0; i < fields; ++i) {
                    idx += ClassAnnotationMetaDataFilter.skipFieldOrMethod(table, idx);
                }
                int methods = table.readUnsignedShort(idx);
                idx += 2;
                for (int i = 0; i < methods; ++i) {
                    idx += ClassAnnotationMetaDataFilter.skipFieldOrMethod(table, idx);
                }
                int attrs = table.readUnsignedShort(idx);
                idx += 2;
                for (int i = 0; i < attrs; ++i) {
                    int name = table.readUnsignedShort(idx);
                    idx += 2;
                    if ("RuntimeVisibleAnnotations".equals(table.readString(table.get(name)))) {
                        return this.matchAnnotations(table, idx + 4);
                    }
                    idx += 4 + table.readInt(idx);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                ClassFormatError cfe = new ClassFormatError(rsrc.getName());
                cfe.initCause(e);
                if (this._log == null || !this._log.isTraceEnabled()) break block7;
                this._log.trace(_loc.get("class-arg", rsrc.getName()), cfe);
            }
        }
        return false;
    }

    private boolean matchAnnotations(ConstantPoolTable table, int idx) {
        int annos = table.readUnsignedShort(idx);
        idx += 2;
        for (int i = 0; i < annos; ++i) {
            int type = table.readUnsignedShort(idx);
            idx += 2;
            if (this.matchAnnotation(table.readString(table.get(type)))) {
                return true;
            }
            int props = table.readUnsignedShort(idx);
            idx += 2;
            for (int j = 0; j < props; ++j) {
                idx += 2;
                idx += ClassAnnotationMetaDataFilter.skipAnnotationPropertyValue(table, idx);
            }
        }
        return false;
    }

    private boolean matchAnnotation(String name) {
        for (int i = 0; i < this._annos.length; ++i) {
            if (!name.equals(this._annos[i])) continue;
            return true;
        }
        return false;
    }

    private static int skipAnnotationPropertyValue(ConstantPoolTable table, int idx) {
        int skipped = 0;
        switch (table.readByte(idx + skipped++)) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 99: 
            case 115: {
                skipped += 2;
                break;
            }
            case 101: {
                skipped += 4;
                break;
            }
            case 91: {
                int size = table.readUnsignedShort(idx + skipped);
                skipped += 2;
                for (int i = 0; i < size; ++i) {
                    skipped += ClassAnnotationMetaDataFilter.skipAnnotationPropertyValue(table, idx + skipped);
                }
                break;
            }
            case 64: {
                int props = table.readUnsignedShort(idx + (skipped += 2));
                skipped += 2;
                for (int j = 0; j < props; ++j) {
                    skipped += 2;
                    skipped += ClassAnnotationMetaDataFilter.skipAnnotationPropertyValue(table, idx + skipped);
                }
                break;
            }
        }
        return skipped;
    }

    private static int skipFieldOrMethod(ConstantPoolTable table, int idx) {
        int attrs = table.readUnsignedShort(idx + 6);
        int skipped = 8;
        for (int i = 0; i < attrs; ++i) {
            int len = table.readInt(idx + skipped + 2);
            skipped += 6 + len;
        }
        return skipped;
    }

    public Log getLog() {
        return this._log;
    }

    public void setLog(Log _log) {
        this._log = _log;
    }
}

