/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.registry.xml.loader;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlLoader {
    private static Log logger = LogFactory.getLog(XmlLoader.class);
    private static Map<String, Unmarshaller> unMarshallers = new HashMap<String, Unmarshaller>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T loadSchemaAndFile(String xsdPath, Class<T> rootClass, InputStream xmlInputStream) throws Exception {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(rootClass.getClassLoader());
            Unmarshaller unMarshaller = XmlLoader.getUnMarshaller(xsdPath, rootClass);
            logger.debug((Object)"Unmarshalling XML", new Object[0]);
            Object object = ((JAXBElement)unMarshaller.unmarshal(xmlInputStream)).getValue();
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
            logger.debug((Object)"Exiting loadSchemaAndFile", new Object[0]);
        }
    }

    private static synchronized Unmarshaller getUnMarshaller(String xsdPath, Class<?> rootClass) throws Exception {
        String identifier = rootClass.getName() + "#" + xsdPath;
        Unmarshaller unMarshaller = unMarshallers.get(identifier);
        if (unMarshaller == null) {
            logger.debug((Object)"Creating new JAXBContext for {0}", new Object[]{rootClass.getPackage().getName()});
            JAXBContext jc = JAXBContext.newInstance((String)rootClass.getPackage().getName());
            unMarshaller = jc.createUnmarshaller();
            logger.debug((Object)"Setting unMarshaller schema", new Object[0]);
            URL xsdURL = rootClass.getClassLoader().getResource(xsdPath);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(xsdURL);
            unMarshaller.setSchema(schema);
            logger.debug((Object)"Putting into cache idenfitier {0}, unMarshaller {1}", new Object[]{identifier, unMarshaller});
            unMarshallers.put(identifier, unMarshaller);
        }
        return unMarshaller;
    }
}

