/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen.objects;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.modelgen.CanonicalModelProperties;
import org.eclipse.persistence.internal.jpa.modelgen.MetadataMirrorFactory;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnit;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceXML;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceXMLMappings;
import org.eclipse.persistence.oxm.XMLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitReader {
    protected ProcessingEnvironment processingEnv;
    protected List<PersistenceUnit> persistenceUnits;

    public PersistenceUnitReader(MetadataMirrorFactory factory) throws IOException {
        this.processingEnv = factory.getProcessingEnvironment();
        this.persistenceUnits = new ArrayList<PersistenceUnit>();
        this.initPersistenceUnits(factory);
    }

    protected void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        }
    }

    protected FileObject getFileObject(String filename, ProcessingEnvironment processingEnv) throws IOException {
        return processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", filename);
    }

    protected InputStream getInputStream(String filename, boolean loadingPersistenceXML) {
        InputStream inputStream = null;
        try {
            FileObject fileObject = this.getFileObject(filename, this.processingEnv);
            inputStream = fileObject.openInputStream();
        }
        catch (IOException ioe) {
            try {
                inputStream = new FileInputStream(filename);
            }
            catch (IOException e) {
                if (loadingPersistenceXML) {
                    throw new RuntimeException("Unable to load persistence.xml : " + ioe.getLocalizedMessage());
                }
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "File was not found: " + filename);
            }
        }
        return inputStream;
    }

    protected HashSet<String> getPersistenceUnitList(ProcessingEnvironment processingEnv) {
        String persistenceUnits = processingEnv.getOptions().get("eclipselink.persistenceunits");
        HashSet<String> persistenceUnitList = null;
        if (persistenceUnits != null) {
            persistenceUnitList = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(persistenceUnits, ",");
            while (st.hasMoreTokens()) {
                persistenceUnitList.add(st.nextToken().trim());
            }
        }
        return persistenceUnitList;
    }

    public List<PersistenceUnit> getPersistenceUnits() {
        return this.persistenceUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPersistenceUnits(MetadataMirrorFactory factory) {
        for (String optionKey : this.processingEnv.getOptions().keySet()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.OTHER, "Found Option : " + optionKey + ", with value: " + this.processingEnv.getOptions().get(optionKey));
        }
        String filename = CanonicalModelProperties.getOption("eclipselink.persistencexml", "META-INF/persistence.xml", this.processingEnv.getOptions());
        HashSet<String> persistenceUnitList = this.getPersistenceUnitList(this.processingEnv);
        InputStream inStream = null;
        try {
            XMLContext context = PersistenceXMLMappings.createXMLContext();
            inStream = this.getInputStream(filename, true);
            PersistenceXML persistenceXML = (PersistenceXML)context.createUnmarshaller().unmarshal(inStream);
            for (SEPersistenceUnitInfo puInfo : persistenceXML.getPersistenceUnitInfos()) {
                if (persistenceUnitList != null && !persistenceUnitList.contains(puInfo.getPersistenceUnitName())) continue;
                this.persistenceUnits.add(new PersistenceUnit(puInfo, factory, this));
            }
            this.closeInputStream(inStream);
        }
        catch (Throwable throwable) {
            this.closeInputStream(inStream);
            throw throwable;
        }
    }
}

