/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.net.Socket;
import org.apache.tomcat.util.net.PoolTcpEndpoint;
import org.apache.tomcat.util.net.TcpConnection;
import org.apache.tomcat.util.threads.ThreadWithAttributes;

class MasterSlaveWorkerThread
implements Runnable {
    protected PoolTcpEndpoint endpoint;
    protected String threadName;
    protected boolean stopped = false;
    private Object threadSync = new Object();
    private Thread thread = null;
    private boolean available = false;
    private Socket socket = null;
    private TcpConnection con = new TcpConnection();
    private Object[] threadData = null;

    public MasterSlaveWorkerThread(PoolTcpEndpoint endpoint, String threadName) {
        this.endpoint = endpoint;
        this.threadName = threadName;
    }

    synchronized void assign(Socket socket) {
        while (this.available) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.socket = socket;
        this.available = true;
        this.notifyAll();
    }

    private synchronized Socket await() {
        while (!this.available) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        Socket socket = this.socket;
        this.available = false;
        this.notifyAll();
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stopped) {
            Socket socket = this.await();
            if (socket == null) continue;
            this.endpoint.processSocket(socket, this.con, this.threadData);
            this.endpoint.recycleWorkerThread(this);
        }
        Object object = this.threadSync;
        synchronized (object) {
            this.threadSync.notifyAll();
        }
    }

    public void start() {
        this.threadData = this.endpoint.getConnectionHandler().init();
        this.thread = new ThreadWithAttributes((Object)null, (Runnable)this);
        this.thread.setName(this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stop() {
        this.stopped = true;
        this.assign(null);
        this.thread = null;
        this.threadData = null;
    }
}

