/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.fetcher.impl.maven2;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public final class Maven2Utils {
    private Maven2Utils() {
    }

    public static String getMaven2Location(String repository, String groupId, String artifactId, String version, String maven2Version, String classifier, String type) {
        String appendedClassifier = "";
        if (classifier != null) {
            appendedClassifier = appendedClassifier.concat("-").concat(classifier);
        }
        String path = Maven2Utils.constructDirectoryPath(groupId, artifactId, version);
        String location = repository.concat("/").concat(path.concat("/").concat(artifactId).concat("-").concat(maven2Version).concat(appendedClassifier).concat(".").concat(type));
        return location;
    }

    public static File getMaven2File(String repository, String groupId, String artifactId, String version, String maven2Version, String classifier, String type) {
        return new File(Maven2Utils.getMaven2Location(repository, groupId, artifactId, version, maven2Version, classifier, type));
    }

    public static URL getMaven2URL(String repository, String groupId, String artifactId, String version, String maven2Version, String classifier, String type) throws MalformedURLException {
        return new URL(Maven2Utils.getMaven2Location(repository, groupId, artifactId, version, maven2Version, classifier, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readChecksum(InputStream inputStream) throws IOException {
        String checksum = "";
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            checksum = bufferedReader.readLine().trim();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.reset();
                    bufferedReader.close();
                }
                catch (IOException e) {}
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.read();
                    inputStreamReader.close();
                }
                catch (IOException e) {}
            }
        }
        return checksum.split(" ")[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMaven2Version(String repository, String groupId, String artifactId, String version, int timeout) {
        String maven2Version = version;
        if (version.endsWith("SNAPSHOT")) {
            String path = Maven2Utils.constructDirectoryPath(groupId, artifactId, version);
            InputStream inputStream = null;
            try {
                URL mavenMetadataURL = new URL(repository.concat(path.concat("/")).concat("maven-metadata.xml"));
                URLConnection connection = mavenMetadataURL.openConnection();
                connection.setReadTimeout(timeout);
                inputStream = connection.getInputStream();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
                Document document = parser.parse(inputStream);
                String timestamp = document.getElementsByTagName("timestamp").item(0).getTextContent();
                String buildNumber = document.getElementsByTagName("buildNumber").item(0).getTextContent();
                maven2Version = version.replace("SNAPSHOT", timestamp.concat("-").concat(buildNumber));
            }
            catch (Exception e) {
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return maven2Version;
    }

    private static String constructDirectoryPath(String groupId, String artifactId, String version) {
        String transformed = groupId.replace('.', '/');
        return transformed.concat("/").concat(artifactId).concat("/").concat(version);
    }
}

