/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.loader;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.loader.FilteringClassLoaderFilters;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;
import org.ow2.util.xmlconfig.XMLConfiguration;
import org.ow2.util.xmlconfig.XMLConfigurationException;
import org.ow2.util.xmlconfig.properties.IPropertyResolver;
import org.ow2.util.xmlconfig.properties.SystemPropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringClassLoader
extends URLClassLoader {
    public static final String XML_FILE = "classloader-default-filtering.xml";
    public static final String MAPPING_FILE = "classloader-default-filtering-mapping.xml";
    private static final String DISABLE_FILTERING_PROPERTY_NAME = "jonas-disable-filtering-class-loader";
    private static Log logger = LogFactory.getLog(FilteringClassLoader.class);
    private boolean enabled = true;
    private boolean disableDefaultFiltering = false;
    private FilteringClassLoaderFilters defaultFilters = null;

    public FilteringClassLoader(ClassLoader parentClassLoader) {
        this(parentClassLoader, false);
    }

    public FilteringClassLoader(ClassLoader parentClassLoader, boolean disableDefaultFiltering) {
        super(new URL[0], parentClassLoader);
        this.disableDefaultFiltering = disableDefaultFiltering;
        if (Boolean.getBoolean(DISABLE_FILTERING_PROPERTY_NAME)) {
            this.enabled = false;
        }
        if (this.enabled && !this.disableDefaultFiltering) {
            this.loadDefaultFilters();
        }
    }

    protected void loadDefaultFilters() {
        File xmlConfigFile = new File(JProp.getConfDir() + File.separator + XML_FILE);
        if (!xmlConfigFile.exists()) {
            logger.warn((Object)("Cannot find the file named '" + xmlConfigFile + "' for filtering classloader resources. Check your JONAS_BASE/conf folder."), new Object[0]);
            return;
        }
        URL xmlconfigFileURL = URLUtils.fileToURL((File)xmlConfigFile);
        XMLConfiguration xmlConfiguration = new XMLConfiguration(MAPPING_FILE);
        xmlConfiguration.addConfigurationFile(xmlconfigFileURL);
        xmlConfiguration.setPropertyResolver((IPropertyResolver)new SystemPropertyResolver());
        HashMap contextualInstances = new HashMap();
        xmlConfiguration.setContextualInstances(contextualInstances);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(FilteringClassLoader.class.getClassLoader());
            xmlConfiguration.configure((Object)this);
        }
        catch (XMLConfigurationException e) {
            throw new IllegalArgumentException("Cannot configure the Filters inside the Filtering Classloader", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.enabled && this.isFiltered(name)) {
            throw new ClassNotFoundException("The class '" + name + "' is a filtered class so it cannot be found in the Application Server classloader." + " The class should be added into the application classloader.");
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public URL getResource(String name) {
        if (this.enabled && this.isFiltered(name)) {
            logger.debug((Object)"The resource ''{0}'' has been asked but as it is a filtered resource, return null", new Object[]{name});
            return null;
        }
        return super.getResource(name);
    }

    protected boolean isFiltered(String name) {
        if (name == null || this.defaultFilters == null) {
            return false;
        }
        List<String> filters = this.defaultFilters.getFilters();
        if (filters != null) {
            for (String pattern : filters) {
                if (!name.matches(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    public FilteringClassLoaderFilters getFilteringClassLoaderFilters() {
        return this.defaultFilters;
    }

    public void setFilteringClassLoaderFilters(FilteringClassLoaderFilters defaultFilters) {
        this.defaultFilters = defaultFilters;
    }
}

