/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer.interceptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.ow2.easybeans.api.EasyBeansInvocationContext;
import org.ow2.easybeans.api.interceptor.EZBInterceptorInvoker;
import org.ow2.easybeans.api.interceptor.EZBInterceptorManager;
import org.ow2.easybeans.enhancer.interceptors.MethodHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.metadata.structures.JMethod;

public class BeanInterceptorInvokerImpl
implements EZBInterceptorInvoker {
    private static final Log LOGGER = LogFactory.getLog(BeanInterceptorInvokerImpl.class);
    private Method method = null;
    private String beanClassname = null;

    public BeanInterceptorInvokerImpl(String beanClassname, JMethod jMethod, ClassLoader classLoader) {
        this.beanClassname = beanClassname;
        this.method = MethodHelper.getMethod(beanClassname, jMethod, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(EasyBeansInvocationContext invocationContext, EZBInterceptorManager interceptorManager) throws Exception {
        boolean isAccessible = this.method.isAccessible();
        LOGGER.debug((Object)"Calling bean with invocationContext ''{0}'' on bean ''{1}'' with parameters ''{2}''", new Object[]{invocationContext, invocationContext.getTarget(), Arrays.asList(invocationContext.getParameters())});
        if (isAccessible) {
            return this.invoke(invocationContext);
        }
        this.method.setAccessible(true);
        try {
            Object object = this.invoke(invocationContext);
            Object var6_5 = null;
            this.method.setAccessible(isAccessible);
            return object;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.method.setAccessible(isAccessible);
            throw throwable;
        }
    }

    private Object invoke(EasyBeansInvocationContext invocationContext) throws Exception {
        try {
            return this.method.invoke(invocationContext.getTarget(), invocationContext);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("[className=");
        sb.append(this.beanClassname);
        sb.append(", method=");
        sb.append(this.method);
        return sb.toString();
    }
}

