/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ant.archive.exploded;

import java.io.File;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.ow2.util.ant.archive.api.IArchive;
import org.ow2.util.ant.archive.info.ArchiveInfo;

public abstract class AbsExplodedArchive
extends Task
implements IArchive {
    private static final String PERSISTENCE_DEPLOYMENT_DESCRIPTOR = "META-INF/persistence.xml";
    private ArchiveInfo archiveInfo = null;

    public AbsExplodedArchive(Project p) {
        this.setProject(p);
    }

    public abstract String getDDStandardName();

    public abstract String getDDSpecificame();

    public void setArchiveInfo(ArchiveInfo archiveInfo) {
        this.archiveInfo = archiveInfo;
    }

    public void addDD() {
        ZipFileSet zipFileSet;
        if (this.archiveInfo.getDD() != null) {
            zipFileSet = new ZipFileSet();
            zipFileSet.setProject(this.getProject());
            zipFileSet.setFile(this.archiveInfo.getDD());
            zipFileSet.setFullpath(this.getDDStandardName());
            this.archiveInfo.getFileSetList().add((FileSet)zipFileSet);
        }
        if (this.archiveInfo.getSpecificDD() != null) {
            zipFileSet = new ZipFileSet();
            zipFileSet.setProject(this.getProject());
            zipFileSet.setFile(this.archiveInfo.getSpecificDD());
            zipFileSet.setFullpath(this.getDDSpecificame());
            this.archiveInfo.getFileSetList().add((FileSet)zipFileSet);
        }
        if (this.archiveInfo.getPersistenceDD() != null) {
            zipFileSet = new ZipFileSet();
            zipFileSet.setProject(this.getProject());
            zipFileSet.setFile(this.archiveInfo.getPersistenceDD());
            zipFileSet.setFullpath(PERSISTENCE_DEPLOYMENT_DESCRIPTOR);
            this.archiveInfo.getFileSetList().add((FileSet)zipFileSet);
        }
    }

    public void execute() {
        this.addDD();
        File destdir = this.archiveInfo.getDest();
        for (FileSet fileSet : this.archiveInfo.getFileSetList()) {
            Copy copy = new Copy();
            copy.setProject(this.getProject());
            copy.setTaskName(this.getTaskName());
            copy.setTodir(destdir);
            if (ZipFileSet.class.getName().equals(fileSet.getClass().getName())) {
                String fullpath;
                ZipFileSet archiveFileSet = (ZipFileSet)fileSet;
                String prefix = archiveFileSet.getPrefix(this.getProject());
                if (prefix != null && !prefix.equals("")) {
                    File toDir = new File(destdir, prefix);
                    copy.setTodir(toDir);
                }
                if ((fullpath = archiveFileSet.getFullpath(this.getProject())) != null && !fullpath.equals("")) {
                    File toFile = new File(destdir, fullpath);
                    copy.setTodir(null);
                    copy.setTofile(toFile);
                }
            }
            copy.addFileset(fileSet);
            copy.execute();
        }
    }
}

