/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ant.archive.exploded;

import java.io.File;
import java.util.List;
import org.apache.tools.ant.Project;
import org.ow2.util.ant.archive.AbsArchive;
import org.ow2.util.ant.archive.Client;
import org.ow2.util.ant.archive.Ejb;
import org.ow2.util.ant.archive.War;
import org.ow2.util.ant.archive.api.IEar;
import org.ow2.util.ant.archive.exploded.AbsExplodedArchive;
import org.ow2.util.ant.archive.info.EarInfo;

public class EarExploded
extends AbsExplodedArchive
implements IEar {
    private static final String DEPLOYMENT_DESCRIPTOR = "META-INF/application.xml";
    private static final String SPECIFIC_DEPLOYMENT_DESCRIPTOR = "META-INF/easybeans.xml";
    private EarInfo earInfo = null;

    public EarExploded(Project p) {
        super(p);
    }

    public void setEarInfo(EarInfo earInfo) {
        this.setArchiveInfo(earInfo);
        this.earInfo = earInfo;
    }

    public String getDDStandardName() {
        return DEPLOYMENT_DESCRIPTOR;
    }

    public void execute() {
        this.earInfo.getDest().mkdirs();
        super.execute();
        List<Ejb> ejbs = this.earInfo.getEjbs();
        List<War> wars = this.earInfo.getWars();
        List<Client> clients = this.earInfo.getClients();
        if (ejbs != null) {
            for (Ejb ejb : ejbs) {
                this.updateArchive(ejb);
                ejb.execute();
            }
        }
        if (wars != null) {
            for (War war : wars) {
                this.updateArchive(war);
                war.execute();
            }
        }
        if (clients != null) {
            for (Client client : clients) {
                this.updateArchive(client);
                client.execute();
            }
        }
    }

    void updateArchive(AbsArchive archive) {
        archive.setDest(new File(this.earInfo.getDest(), archive.getDest().getName()));
    }

    public String getDDSpecificame() {
        return SPECIFIC_DEPLOYMENT_DESCRIPTOR;
    }
}

