/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.jaxws.handler.builder;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.PortInfo;
import org.ow2.jonas.ws.jaxws.handler.builder.HandlerChainBuilder;
import org.ow2.util.ee.metadata.common.api.xml.struct.IHandlerChains;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.HandlerChainsLoader;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.ParsingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHandlerChainBuilder
extends HandlerChainBuilder {
    private IHandlerChains handlerChainsElement;

    public AnnotationHandlerChainBuilder(Class<?> clazz) {
        HandlerChainAnnotation annotation = this.findHandlerChainAnnotation(clazz, true);
        if (annotation != null) {
            String file = annotation.getHandlerChain().file().trim();
            if (file == null || "".equals(file)) {
                throw new WebServiceException("@HandlerChain annotation on '" + clazz + "' is missing a valid 'file' value.");
            }
            URL location = this.getHandlerChainsLocation(file, annotation.getDeclaringClass());
            try {
                this.handlerChainsElement = HandlerChainsLoader.loadHandlerChains((URL)location, (boolean)true);
            }
            catch (ParsingException e) {
                throw new WebServiceException("Cannot parse <handler-chains>", (Throwable)e);
            }
        }
    }

    @Override
    public List<Handler> buildHandlerChain(PortInfo info, ClassLoader loader) {
        List<Handler> handlers = Collections.emptyList();
        if (this.handlerChainsElement != null) {
            handlers = this.buildHandlerChain(this.handlerChainsElement, info, loader);
        }
        return handlers;
    }

    private URL getHandlerChainsLocation(String file, Class<?> declaringClass) {
        URL location;
        try {
            location = new URL(file);
        }
        catch (IOException mue) {
            location = declaringClass.getResource(file);
        }
        return location;
    }

    private HandlerChainAnnotation findHandlerChainAnnotation(Class<?> clazz, boolean searchSEI) {
        HandlerChainAnnotation annotation = null;
        HandlerChain chain = clazz.getAnnotation(HandlerChain.class);
        if (chain == null) {
            WebService ws;
            if (searchSEI && (ws = clazz.getAnnotation(WebService.class)) != null && !"".equals(ws.endpointInterface())) {
                Class<?> sei;
                ClassLoader loader = clazz.getClassLoader();
                String seClassname = ws.endpointInterface();
                try {
                    sei = Class.forName(seClassname, true, loader);
                }
                catch (ClassNotFoundException e) {
                    throw new WebServiceException("Cannot load SEI class '" + seClassname + "'", (Throwable)e);
                }
                annotation = this.findHandlerChainAnnotation(sei, false);
            }
            if (annotation == null) {
                for (Class<?> itf : clazz.getInterfaces()) {
                    HandlerChain itfHC = itf.getAnnotation(HandlerChain.class);
                    if (itfHC == null) continue;
                    annotation = new HandlerChainAnnotation(itfHC, itf);
                    break;
                }
            }
        } else {
            annotation = new HandlerChainAnnotation(chain, clazz);
        }
        return annotation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HandlerChainAnnotation {
        private HandlerChain handlerChain;
        private Class<?> declaringClass;

        public HandlerChainAnnotation(HandlerChain chain, Class<?> declaringClass) {
            this.handlerChain = chain;
            this.declaringClass = declaringClass;
        }

        public HandlerChain getHandlerChain() {
            return this.handlerChain;
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }
    }
}

