/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.finder;

import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.generators.wsgen.finder.J2EEWebServicesFinder;
import org.ow2.jonas.generators.wsgen.finder.ServiceRefFinder;
import org.ow2.jonas.generators.wsgen.finder.WebServicesXmlFinder;
import org.ow2.jonas.lib.util.Log;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GenericWSFinder
implements J2EEWebServicesFinder {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.generators.wsgen");
    private J2EEArchive archive = null;
    private String descriptorName = null;

    public GenericWSFinder(J2EEArchive archive, String descriptorName) {
        this.archive = archive;
        this.descriptorName = descriptorName;
    }

    public boolean find() {
        WebServicesXmlFinder wsFinder = new WebServicesXmlFinder(this.archive);
        try {
            wsFinder.init(this.getSAXParser());
        }
        catch (Exception e) {
            logger.log(BasicLevel.DEBUG, (Object)"Cannot return a SAXParser", (Throwable)e);
        }
        ServiceRefFinder srFinder = new ServiceRefFinder();
        try {
            InputStream is = this.archive.getInputStream(this.descriptorName);
            SAXParser parser = this.getSAXParser();
            parser.parse(is, (DefaultHandler)srFinder);
        }
        catch (Exception e) {
            logger.log(BasicLevel.DEBUG, (Object)"Cannot return a SAXParser", (Throwable)e);
        }
        return wsFinder.find() || srFinder.find();
    }

    protected SAXParser getSAXParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return factory.newSAXParser();
    }
}

