/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.naming.Context;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.ejb.SessionDesc;
import org.ow2.jonas.deployment.ejb.SessionStatelessDesc;
import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.ejb21.JContext;
import org.ow2.jonas.lib.ejb21.JServiceEndpointHome;
import org.ow2.jonas.lib.ejb21.JSessionContext;
import org.ow2.jonas.lib.ejb21.JSessionFactory;
import org.ow2.jonas.lib.ejb21.JSessionRemote;
import org.ow2.jonas.lib.ejb21.JSessionSwitch;
import org.ow2.jonas.lib.ejb21.JStatelessContext;
import org.ow2.jonas.lib.ejb21.JStatelessSwitch;
import org.ow2.jonas.lib.ejb21.JTimerService;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.timer.TraceTimer;

public class JStatelessFactory
extends JSessionFactory {
    protected List bctxlist = new ArrayList();
    protected JServiceEndpointHome sehome = null;
    protected int instanceCount = 0;
    protected int minPoolSize = 0;
    protected int maxCacheSize = 0;
    private static final int MAX_NB_RETRY = 2;

    public JStatelessFactory(SessionStatelessDesc dd, JContainer cont) {
        super((SessionDesc)dd, cont);
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        Class<?> sehomeclass = null;
        String clname = dd.getFullWrpSEHomeName();
        if (clname != null) {
            try {
                sehomeclass = cont.getClassLoader().loadClass(clname);
            }
            catch (ClassNotFoundException e) {
                throw new EJBException(this.ejbname + " Cannot load " + clname, (Exception)e);
            }
            if (TraceEjb.isDebugIc()) {
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)(this.ejbname + ": " + clname + " loaded"));
            }
            try {
                int nbp = 2;
                Class[] ptype = new Class[nbp];
                Object[] pobj = new Object[nbp];
                ptype[0] = SessionStatelessDesc.class;
                pobj[0] = dd;
                ptype[1] = JStatelessFactory.class;
                pobj[1] = this;
                this.sehome = (JServiceEndpointHome)sehomeclass.getConstructor(ptype).newInstance(pobj);
            }
            catch (Exception e) {
                throw new EJBException(this.ejbname + " Cannot create serviceEndpointHome ", e);
            }
            try {
                this.sehome.register();
            }
            catch (Exception e) {
                throw new EJBException(this.ejbname + " Cannot register serviceEndpointHome ", e);
            }
        }
        this.isStateful = false;
        this.maxCacheSize = dd.getCacheMax();
        this.minPoolSize = dd.getPoolMin();
        if (this.maxCacheSize > 0 && TraceEjb.isDebugSwapper()) {
            TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)(" maxCacheSize = " + this.maxCacheSize));
        }
        this.singleswitch = this.timeout == 0 && dd.isSingleton();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initInstancePool() {
        JStatelessSwitch ss = null;
        if (this.minPoolSize != 0 || this.singleswitch) {
            try {
                ss = (JStatelessSwitch)this.createEJB();
            }
            catch (RemoteException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ejbname + " cannot create new session"), (Throwable)e);
                throw new EJBException(this.ejbname + " Cannot create session for pool: ", (Exception)e);
            }
        }
        if (this.minPoolSize != 0) {
            TraceEjb.interp.log(BasicLevel.INFO, (Object)("pre-allocate a set of " + this.minPoolSize + " stateless session instances"));
            Context bnctx = this.setComponentContext();
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.myClassLoader());
            try {
                List list = this.bctxlist;
                synchronized (list) {
                    for (int i = 0; i < this.minPoolSize; ++i) {
                        JStatelessContext ctx = null;
                        try {
                            ctx = this.createNewInstance(ss);
                            if (ctx != null) {
                                this.bctxlist.add(ctx);
                                continue;
                            }
                            TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ejbname + " null instance"));
                            continue;
                        }
                        catch (Exception e) {
                            TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ejbname + " cannot create new instance"), (Throwable)e);
                            throw new EJBException(this.ejbname + " Cannot init pool of instances ", e);
                        }
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
                this.resetComponentContext(bnctx);
            }
        }
        if (ss != null && !this.singleswitch) {
            ss.stopTimer();
            ss.noLongerUsed();
        }
    }

    public JServiceEndpointHome getSEHome() {
        return this.sehome;
    }

    public int getPoolSize() {
        return this.bctxlist.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reduceCache() {
        List list = this.bctxlist;
        synchronized (list) {
            while (this.bctxlist.size() > this.minPoolSize) {
                ListIterator i = this.bctxlist.listIterator();
                if (!i.hasNext()) continue;
                i.next();
                i.remove();
                --this.instanceCount;
            }
        }
    }

    public TimerService getTimerService() {
        if (this.myTimerService == null) {
            this.myTimerService = new JTimerService(this);
        }
        return this.myTimerService;
    }

    public JSessionSwitch createNewSession() throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        JStatelessSwitch bs = new JStatelessSwitch(this);
        return bs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSessionContext getJContext(JSessionSwitch ss) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        JStatelessContext bctx = null;
        List list = this.bctxlist;
        synchronized (list) {
            try {
                ListIterator i = this.bctxlist.listIterator();
                if (i.hasNext()) {
                    bctx = (JStatelessContext)i.next();
                    i.remove();
                    if (bctx != null) {
                        bctx.initSessionContext(ss);
                    } else {
                        TraceEjb.interp.log(BasicLevel.ERROR, (Object)"null elt in bctxlist");
                    }
                }
            }
            catch (IndexOutOfBoundsException ex) {
                // empty catch block
            }
        }
        if (bctx == null) {
            try {
                bctx = this.createNewInstance(ss);
            }
            catch (Exception e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)("exception:" + e));
                throw new EJBException("Cannot create a new instance", e);
            }
        }
        if (this.maxCacheSize != 0 && TraceEjb.isDebugSwapper()) {
            TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)("nb instances " + this.getCacheSize()));
        }
        return bctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseJContext(JContext ctx) {
        if (ctx == null) {
            TraceEjb.swapper.log(BasicLevel.ERROR, (Object)"null ctx!");
            return;
        }
        JStatelessContext bctx = (JStatelessContext)ctx;
        List list = this.bctxlist;
        synchronized (list) {
            if (this.maxCacheSize != 0 && this.instanceCount > this.maxCacheSize) {
                if (TraceEjb.isDebugSwapper()) {
                    TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)("too many instances :" + this.instanceCount + ", max=" + this.maxCacheSize));
                }
                --this.instanceCount;
            } else {
                this.bctxlist.add(bctx);
            }
        }
        if (this.maxCacheSize != 0 && TraceEjb.isDebugSwapper()) {
            TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)("nb instances " + this.getCacheSize()));
        }
    }

    public void notifyTimeout(Timer timer) {
        if (this.stopped) {
            TraceEjb.mdb.log(BasicLevel.WARN, (Object)"Container stopped");
            return;
        }
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"");
        }
        JSessionSwitch bs = null;
        if (this.sessionList.size() > 0) {
            JSessionRemote remote;
            if (TraceEjb.isDebugIc()) {
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"get a JStatelessSwitch from the pool");
            }
            if ((remote = (bs = (JSessionSwitch)this.sessionList.remove(0)).getRemote()) != null && !remote.exportObject()) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"bad JSessionSwitch found in pool.");
            }
        } else {
            if (TraceEjb.isDebugIc()) {
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"create a new JStatelessSwitch");
            }
            try {
                bs = new JStatelessSwitch(this);
            }
            catch (RemoteException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"Notify Timeout - Unexpected : ", (Throwable)e);
                return;
            }
        }
        for (int nbretry = 0; nbretry < 2; ++nbretry) {
            RequestCtx rctx = this.preInvoke(this.getTimerTxAttribute());
            JSessionContext bctx = null;
            try {
                bctx = bs.getICtx(rctx.currTx);
                TimedObject instance = (TimedObject)bctx.getInstance();
                this.checkSecurity(null);
                instance.ejbTimeout(timer);
                this.releaseJContext(bctx);
                if (rctx.currTx != null && rctx.currTx.getStatus() == 1) continue;
                break;
            }
            catch (EJBException e) {
                rctx.sysExc = e;
                throw e;
            }
            catch (RuntimeException e) {
                rctx.sysExc = e;
                throw new EJBException("RuntimeException thrown by an enterprise Bean", (Exception)e);
            }
            catch (Error e) {
                rctx.sysExc = e;
                throw new EJBException("Error thrown by an enterprise Bean" + e);
            }
            catch (RemoteException e) {
                rctx.sysExc = e;
                throw new EJBException("Remote Exception raised:", (Exception)e);
            }
            catch (SystemException e) {
                rctx.sysExc = e;
                throw new EJBException("Cannot get transaction status:", (Exception)((Object)e));
            }
            finally {
                this.postInvoke(rctx);
            }
        }
        bs.timeoutExpired(null);
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public int getCacheSize() {
        return this.instanceCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JStatelessContext createNewInstance(JSessionSwitch ss) throws Exception {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        SessionBean bean = null;
        try {
            bean = (SessionBean)this.beanclass.newInstance();
        }
        catch (InstantiationException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ejbname + " cannot instantiate session bean"));
            throw e;
        }
        catch (IllegalAccessException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ejbname + " Cannot instantiate SessionBean"));
            throw e;
        }
        JStatelessContext bctx = new JStatelessContext(this, bean);
        bean.setSessionContext((SessionContext)bctx);
        bctx.setPassive();
        bctx.initSessionContext(ss);
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"call ejbCreate on the instance");
        }
        try {
            this.beanclass.getMethod("ejbCreate", null).invoke((Object)bean, (Object[])null);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ejbname + " cannot invoke ejbCreate on Stateless Session " + t.getMessage()), t);
        }
        catch (Exception e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ejbname + " cannot call ejbCreate on Stateless Session " + e.getMessage()), (Throwable)e);
        }
        bctx.setActive();
        List list = this.bctxlist;
        synchronized (list) {
            ++this.instanceCount;
        }
        return bctx;
    }

    public void storeInstances(Transaction tx) {
    }
}

