/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.base;

import org.ow2.jonas.web.JWebContainerService;
import org.ow2.jonas.web.base.proxy.HttpOnDemandProxy;
import org.ow2.jonas.web.base.proxy.HttpOnDemandProxyException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.impl.deployer.AbsDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WARDeployer
extends AbsDeployer {
    private Log logger = LogFactory.getLog(WARDeployer.class);
    private JWebContainerService webContainerService = null;
    private HttpOnDemandProxy onDemandProxy = null;

    public void doDeploy(IDeployable<?> deployable) throws DeployerException {
        this.logger.info((Object)"Deploying {0}", new Object[]{deployable.getShortName()});
        if (this.onDemandProxy != null) {
            try {
                this.onDemandProxy.addWar((WARDeployable)WARDeployable.class.cast(deployable));
            }
            catch (HttpOnDemandProxyException e) {
                throw new DeployerException("Cannot deploy the War deployable '" + deployable + "'.", (Throwable)e);
            }
        }
        try {
            this.webContainerService.registerWar((WARDeployable)WARDeployable.class.cast(deployable));
        }
        catch (Exception e) {
            throw new DeployerException("Cannot deploy the War deployable '" + deployable + "'.", (Throwable)e);
        }
    }

    public void doUndeploy(IDeployable<?> deployable) throws DeployerException {
        this.logger.info((Object)"Undeploying {0}", new Object[]{deployable.getShortName()});
        if (this.onDemandProxy != null) {
            try {
                this.onDemandProxy.removeWar((WARDeployable)WARDeployable.class.cast(deployable));
            }
            catch (HttpOnDemandProxyException e) {
                throw new DeployerException("Cannot undeploy the War '" + deployable + "'.", (Throwable)e);
            }
        }
        try {
            this.webContainerService.unRegisterWar((WARDeployable)WARDeployable.class.cast(deployable));
        }
        catch (Exception e) {
            throw new DeployerException("Cannot undeploy the War '" + deployable + "'.", (Throwable)e);
        }
    }

    public boolean supports(IDeployable<?> deployable) {
        return WARDeployable.class.isInstance(deployable);
    }

    public void setWebContainerService(JWebContainerService webContainerService) {
        this.webContainerService = webContainerService;
    }

    public HttpOnDemandProxy getOnDemandProxy() {
        return this.onDemandProxy;
    }

    public void setOnDemandProxy(HttpOnDemandProxy onDemandProxy) {
        this.onDemandProxy = onDemandProxy;
    }
}

