/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Realm;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.util.MD5Encoder;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class DigestAuthenticator
extends AuthenticatorBase {
    private static final Log log = LogFactory.getLog(DigestAuthenticator.class);
    protected static final MD5Encoder md5Encoder = new MD5Encoder();
    protected static final String info = "org.apache.catalina.authenticator.DigestAuthenticator/1.0";
    protected static volatile MessageDigest md5Helper;
    protected String key = "Catalina";

    public DigestAuthenticator() {
        try {
            if (md5Helper == null) {
                md5Helper = MessageDigest.getInstance("MD5");
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            String ssoId;
            if (log.isDebugEnabled()) {
                log.debug("Already authenticated '" + principal.getName() + "'");
            }
            if ((ssoId = (String)request.getNote("org.apache.catalina.request.SSOID")) != null) {
                this.associate(ssoId, request.getSessionInternal(true));
            }
            return true;
        }
        String authorization = request.getHeader("authorization");
        if (authorization != null && (principal = DigestAuthenticator.findPrincipal(request, authorization, this.context.getRealm())) != null) {
            String username = this.parseUsername(authorization);
            this.register(request, response, principal, "DIGEST", username, null);
            return true;
        }
        String nOnce = this.generateNOnce(request);
        this.setAuthenticateHeader(request, response, config, nOnce);
        response.sendError(401);
        return false;
    }

    @Override
    protected String getAuthMethod() {
        return "DIGEST";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Principal findPrincipal(Request request, String authorization, Realm realm) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Digest ")) {
            return null;
        }
        authorization = authorization.substring(7).trim();
        String[] tokens = authorization.split(",(?=(?:[^\"]*\"[^\"]*\")+$)");
        String userName = null;
        String realmName = null;
        String nOnce = null;
        String nc = null;
        String cnonce = null;
        String qop = null;
        String uri = null;
        String response = null;
        String method = request.getMethod();
        for (int i = 0; i < tokens.length; ++i) {
            String currentToken = tokens[i];
            if (currentToken.length() == 0) continue;
            int equalSign = currentToken.indexOf(61);
            if (equalSign < 0) {
                return null;
            }
            String currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1).trim();
            if ("username".equals(currentTokenName)) {
                userName = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("realm".equals(currentTokenName)) {
                realmName = DigestAuthenticator.removeQuotes(currentTokenValue, true);
            }
            if ("nonce".equals(currentTokenName)) {
                nOnce = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("nc".equals(currentTokenName)) {
                nc = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("cnonce".equals(currentTokenName)) {
                cnonce = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("qop".equals(currentTokenName)) {
                qop = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("uri".equals(currentTokenName)) {
                uri = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if (!"response".equals(currentTokenName)) continue;
            response = DigestAuthenticator.removeQuotes(currentTokenValue);
        }
        if (userName == null || realmName == null || nOnce == null || uri == null || response == null) {
            return null;
        }
        String a2 = method + ":" + uri;
        byte[] buffer = null;
        MessageDigest equalSign = md5Helper;
        synchronized (equalSign) {
            buffer = md5Helper.digest(a2.getBytes());
        }
        String md5a2 = md5Encoder.encode(buffer);
        return realm.authenticate(userName, response, nOnce, nc, cnonce, qop, realmName, md5a2);
    }

    protected String parseUsername(String authorization) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Digest ")) {
            return null;
        }
        authorization = authorization.substring(7).trim();
        StringTokenizer commaTokenizer = new StringTokenizer(authorization, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String currentToken = commaTokenizer.nextToken();
            int equalSign = currentToken.indexOf(61);
            if (equalSign < 0) {
                return null;
            }
            String currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1).trim();
            if (!"username".equals(currentTokenName)) continue;
            return DigestAuthenticator.removeQuotes(currentTokenValue);
        }
        return null;
    }

    protected static String removeQuotes(String quotedString, boolean quotesRequired) {
        if (quotedString.length() > 0 && quotedString.charAt(0) != '\"' && !quotesRequired) {
            return quotedString;
        }
        if (quotedString.length() > 2) {
            return quotedString.substring(1, quotedString.length() - 1);
        }
        return new String();
    }

    protected static String removeQuotes(String quotedString) {
        return DigestAuthenticator.removeQuotes(quotedString, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateNOnce(Request request) {
        long currentTime = System.currentTimeMillis();
        String nOnceValue = request.getRemoteAddr() + ":" + currentTime + ":" + this.key;
        byte[] buffer = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            buffer = md5Helper.digest(nOnceValue.getBytes());
        }
        nOnceValue = md5Encoder.encode(buffer);
        return nOnceValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAuthenticateHeader(HttpServletRequest request, HttpServletResponse response, LoginConfig config, String nOnce) {
        String realmName = config.getRealmName();
        if (realmName == null) {
            realmName = "Authentication required";
        }
        byte[] buffer = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            buffer = md5Helper.digest(nOnce.getBytes());
        }
        String authenticateHeader = "Digest realm=\"" + realmName + "\", " + "qop=\"auth\", nonce=\"" + nOnce + "\", " + "opaque=\"" + md5Encoder.encode(buffer) + "\"";
        response.setHeader("WWW-Authenticate", authenticateHeader);
    }
}

