/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.tuple.lib;

import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.VariableOperand;
import org.objectweb.medor.lib.Log;
import org.objectweb.medor.query.api.CalculatedField;
import org.objectweb.medor.tuple.api.Tuple;
import org.objectweb.medor.tuple.api.TupleLoader;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class GeneralTupleLoader
implements TupleLoader {
    private Logger logger;
    private int[] indexes;
    TupleStructure ts;

    public GeneralTupleLoader(int[] ranges, TupleStructure ts) {
        this.indexes = ranges;
        this.ts = ts;
        this.logger = Log.getLoggerFactory().getLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTuple(Tuple sourceBuffer, VariableOperand[] temp, ParameterOperand[] parameters) throws MedorException, ExpressionException {
        boolean debug = this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG);
        block45: for (int i = 0; i < temp.length; ++i) {
            PType type = this.ts.getField(i + 1).getType();
            Expression cField = null;
            if (this.indexes[i] == -1) {
                cField = ((CalculatedField)this.ts.getField(i + 1)).getExpression();
            }
            switch (type.getTypeCode()) {
                case 4: {
                    Operand op;
                    Expression expression;
                    if (this.indexes[i] != -1) {
                        temp[i].setValue(sourceBuffer.getInt(this.indexes[i]));
                        temp[i].setIsDefined(sourceBuffer.isDefined(this.indexes[i]));
                    } else {
                        expression = cField;
                        synchronized (expression) {
                            cField.compileExpression();
                            op = cField.evaluate(parameters, sourceBuffer);
                            temp[i].setValue(op.getInt());
                            temp[i].setIsDefined(op.isDefined());
                        }
                    }
                    if (!debug) continue block45;
                    this.logger.log(BasicLevel.DEBUG, (Object)("Value assigned [" + i + "]= " + temp[i].getInt()));
                    continue block45;
                }
                case 3: {
                    Operand op;
                    Expression expression;
                    if (this.indexes[i] != -1) {
                        temp[i].setValue(sourceBuffer.getShort(this.indexes[i]));
                        temp[i].setIsDefined(sourceBuffer.isDefined(this.indexes[i]));
                    } else {
                        expression = cField;
                        synchronized (expression) {
                            cField.compileExpression();
                            op = cField.evaluate(parameters, sourceBuffer);
                            temp[i].setValue(op.getShort());
                            temp[i].setIsDefined(op.isDefined());
                        }
                    }
                    if (!debug) continue block45;
                    this.logger.log(BasicLevel.DEBUG, (Object)("Value assigned [" + i + "]= " + temp[i].getShort()));
                    continue block45;
                }
                case 2: {
                    Operand op;
                    Expression expression;
                    if (this.indexes[i] != -1) {
                        temp[i].setValue(sourceBuffer.getByte(this.indexes[i]));
                        temp[i].setIsDefined(sourceBuffer.isDefined(this.indexes[i]));
                    } else {
                        expression = cField;
                        synchronized (expression) {
                            cField.compileExpression();
                            op = cField.evaluate(parameters, sourceBuffer);
                            temp[i].setValue(op.getByte());
                            temp[i].setIsDefined(op.isDefined());
                        }
                    }
                    if (!debug) continue block45;
                    this.logger.log(BasicLevel.DEBUG, (Object)("Value assigned [" + i + "]= " + temp[i].getByte()));
                    continue block45;
                }
                case 5: {
                    Operand op;
                    Expression expression;
                    if (this.indexes[i] != -1) {
                        temp[i].setValue(sourceBuffer.getLong(this.indexes[i]));
                        temp[i].setIsDefined(sourceBuffer.isDefined(this.indexes[i]));
                    } else {
                        expression = cField;
                        synchronized (expression) {
                            cField.compileExpression();
                            op = cField.evaluate(parameters, sourceBuffer);
                            temp[i].setValue(op.getLong());
                            temp[i].setIsDefined(op.isDefined());
                        }
                    }
                    if (!debug) continue block45;
                    this.logger.log(BasicLevel.DEBUG, (Object)("Value assigned [" + i + "]= " + temp[i].getLong()));
                    continue block45;
                }
                case 7: {
                    Operand op;
                    Expression expression;
                    if (this.indexes[i] != -1) {
                        temp[i].setValue(sourceBuffer.getDouble(this.indexes[i]));
                        temp[i].setIsDefined(sourceBuffer.isDefined(this.indexes[i]));
                    } else {
                        expression = cField;
                        synchronized (expression) {
                            cField.compileExpression();
                            op = cField.evaluate(parameters, sourceBuffer);
                            temp[i].setValue(op.getDouble());
                            temp[i].setIsDefined(op.isDefined());
                        }
                    }
                    if (!debug) continue block45;
                    this.logger.log(BasicLevel.DEBUG, (Object)("Value assigned [" + i + "]= " + temp[i].getDouble()));
                    continue block45;
                }
                case 0: {
                    Operand op;
                    Expression expression;
                    if (this.indexes[i] != -1) {
                        temp[i].setValue(sourceBuffer.getBoolean(this.indexes[i]));
                        temp[i].setIsDefined(sourceBuffer.isDefined(this.indexes[i]));
                    } else {
                        expression = cField;
                        synchronized (expression) {
                            cField.compileExpression();
                            op = cField.evaluate(parameters, sourceBuffer);
                            temp[i].setValue(op.getBoolean());
                            temp[i].setIsDefined(op.isDefined());
                        }
                    }
                    if (!debug) continue block45;
                    this.logger.log(BasicLevel.DEBUG, (Object)("Value assigned [" + i + "]= " + temp[i].getBoolean()));
                    continue block45;
                }
                case 6: {
                    Operand op;
                    if (this.indexes[i] != -1) {
                        temp[i].setValue(sourceBuffer.getFloat(this.indexes[i]));
                        temp[i].setIsDefined(sourceBuffer.isDefined(this.indexes[i]));
                        continue block45;
                    }
                    Expression expression = cField;
                    synchronized (expression) {
                        cField.compileExpression();
                        op = cField.evaluate(parameters, sourceBuffer);
                        temp[i].setValue(op.getFloat());
                        temp[i].setIsDefined(op.isDefined());
                        continue block45;
                    }
                }
                case 16: {
                    Operand op;
                    Expression expression;
                    if (this.indexes[i] != -1) {
                        temp[i].setValue(sourceBuffer.getString(this.indexes[i]));
                        temp[i].setIsDefined(sourceBuffer.isDefined(this.indexes[i]));
                    } else {
                        expression = cField;
                        synchronized (expression) {
                            cField.compileExpression();
                            op = cField.evaluate(parameters, sourceBuffer);
                            temp[i].setValue(op.getString());
                            temp[i].setIsDefined(op.isDefined());
                        }
                    }
                    if (!debug) continue block45;
                    this.logger.log(BasicLevel.DEBUG, (Object)("Value assigned [" + i + "]= " + temp[i].getString()));
                    continue block45;
                }
                case 1: {
                    Operand op;
                    Expression expression;
                    if (this.indexes[i] != -1) {
                        temp[i].setValue(sourceBuffer.getChar(this.indexes[i]));
                        temp[i].setIsDefined(sourceBuffer.isDefined(this.indexes[i]));
                    } else {
                        expression = cField;
                        synchronized (expression) {
                            cField.compileExpression();
                            op = cField.evaluate(parameters, sourceBuffer);
                            temp[i].setValue(op.getChar());
                            temp[i].setIsDefined(op.isDefined());
                        }
                    }
                    if (!debug) continue block45;
                    this.logger.log(BasicLevel.DEBUG, (Object)("Value assigned [" + i + "]= " + temp[i].getChar()));
                    continue block45;
                }
                case 17: {
                    Operand op;
                    Expression expression;
                    if (this.indexes[i] != -1) {
                        temp[i].setValue(sourceBuffer.getDate(this.indexes[i]));
                        temp[i].setIsDefined(sourceBuffer.isDefined(this.indexes[i]));
                    } else {
                        expression = cField;
                        synchronized (expression) {
                            cField.compileExpression();
                            op = cField.evaluate(parameters, sourceBuffer);
                            temp[i].setValue(op.getDate());
                            temp[i].setIsDefined(op.isDefined());
                        }
                    }
                    if (!debug) continue block45;
                    this.logger.log(BasicLevel.DEBUG, (Object)("Value assigned [" + i + "]= " + temp[i].getDate()));
                    continue block45;
                }
                default: {
                    Operand op;
                    Expression expression;
                    if (this.indexes[i] != -1) {
                        temp[i].setValue(sourceBuffer.getObject(this.indexes[i]));
                        temp[i].setIsDefined(sourceBuffer.isDefined(this.indexes[i]));
                    } else {
                        expression = cField;
                        synchronized (expression) {
                            cField.compileExpression();
                            op = cField.evaluate(parameters, sourceBuffer);
                            temp[i].setValue(op.getObject());
                            temp[i].setIsDefined(op.isDefined());
                        }
                    }
                    if (!debug) continue block45;
                    this.logger.log(BasicLevel.DEBUG, (Object)("Value assigned [" + i + "]= " + temp[i].getObject()));
                }
            }
        }
    }

    public int[] getFieldIndexes() {
        return this.indexes;
    }

    public void setFieldIndexes(int[] indexes) {
        this.indexes = indexes;
    }

    public TupleStructure getTupleStructure() {
        return this.ts;
    }
}

