/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy;

import javax.xml.namespace.QName;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ws.security.policy.SPConstants;

public final class SP12Constants
extends SPConstants {
    public static final SP12Constants INSTANCE = new SP12Constants();
    public static final String SP_NS = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702";
    public static final String SP_PREFIX = "sp";
    public static final QName INCLUDE_TOKEN = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "IncludeToken", "sp");
    public static final String INCLUDE_NEVER = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702/IncludeToken/Never";
    public static final String INCLUDE_ONCE = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702/IncludeToken/Once";
    public static final String INCLUDE_ALWAYS_TO_RECIPIENT = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702/IncludeToken/AlwaysToRecipient";
    public static final String INCLUDE_ALWAYS_TO_INITIATOR = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702/IncludeToken/AlwaysToInitiator";
    public static final String INCLUDE_ALWAYS = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702/IncludeToken/Always";
    public static final QName TRUST_13 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Trust13", "sp");
    public static final QName REQUIRE_CLIENT_CERTIFICATE = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireClientCertificate", "sp");
    public static final QName HTTP_BASIC_AUTHENTICATION = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "HttpBasicAuthentication", "sp");
    public static final QName HTTP_DIGEST_AUTHENTICATION = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "HttpDigestAuthentication", "sp");
    public static final QName ATTR_XPATH_VERSION = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "XPathVersion", "sp");
    public static final QName TRANSPORT_BINDING = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "TransportBinding", "sp");
    public static final QName ALGORITHM_SUITE = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "AlgorithmSuite", "sp");
    public static final QName LAYOUT = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Layout", "sp");
    public static final QName INCLUDE_TIMESTAMP = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "IncludeTimestamp", "sp");
    public static final QName ONLY_SIGN_ENTIRE_HEADERS_AND_BODY = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "OnlySignEntireHeadersAndBody", "sp");
    public static final QName TRANSPORT_TOKEN = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "TransportToken", "sp");
    public static final QName HTTPS_TOKEN = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "HttpsToken", "sp");
    public static final QName SECURITY_CONTEXT_TOKEN = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SecurityContextToken", "sp");
    public static final QName SECURE_CONVERSATION_TOKEN = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SecureConversationToken", "sp");
    public static final QName SIGNATURE_TOKEN = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SignatureToken", "sp");
    public static final QName SIGNED_PARTS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SignedParts", "sp");
    public static final QName ENCRYPTED_PARTS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "EncryptedParts", "sp");
    public static final QName SIGNED_ELEMENTS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SignedElements", "sp");
    public static final QName ENCRYPTED_ELEMENTS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "EncryptedElements", "sp");
    public static final QName REQUIRED_ELEMENTS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequiredElements", "sp");
    public static final QName REQUIRED_PARTS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequiredParts", "sp");
    public static final QName CONTENT_ENCRYPTED_ELEMENTS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "ContentEncryptedElements", "sp");
    public static final QName USERNAME_TOKEN = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "UsernameToken", "sp");
    public static final QName KEYVALUE_TOKEN = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "KeyValueToken", "sp");
    public static final QName WSS_USERNAME_TOKEN10 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssUsernameToken10", "sp");
    public static final QName WSS_USERNAME_TOKEN11 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssUsernameToken11", "sp");
    public static final QName ENCRYPTION_TOKEN = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "EncryptionToken", "sp");
    public static final QName X509_TOKEN = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "X509Token", "sp");
    public static final QName WSS_X509_V1_TOKEN_10 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssX509V1Token10", "sp");
    public static final QName WSS_X509_V3_TOKEN_10 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssX509V3Token10", "sp");
    public static final QName WSS_X509_PKCS7_TOKEN_10 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssX509Pkcs7Token10", "sp");
    public static final QName WSS_X509_PKI_PATH_V1_TOKEN_10 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssX509PkiPathV1Token10", "sp");
    public static final QName WSS_X509_V1_TOKEN_11 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssX509V1Token11", "sp");
    public static final QName WSS_X509_V3_TOKEN_11 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssX509V3Token11", "sp");
    public static final QName WSS_X509_PKCS7_TOKEN_11 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssX509Pkcs7Token11", "sp");
    public static final QName WSS_X509_PKI_PATH_V1_TOKEN_11 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssX509PkiPathV1Token11", "sp");
    public static final QName ISSUED_TOKEN = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "IssuedToken", "sp");
    public static final QName SUPPORTING_TOKENS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SupportingTokens", "sp");
    public static final QName SIGNED_SUPPORTING_TOKENS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SignedSupportingTokens", "sp");
    public static final QName ENDORSING_SUPPORTING_TOKENS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "EndorsingSupportingTokens", "sp");
    public static final QName SIGNED_ENDORSING_SUPPORTING_TOKENS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SignedEndorsingSupportingTokens", "sp");
    public static final QName ENCRYPTED_SUPPORTING_TOKENS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "EncryptedSupportingTokens", "sp");
    public static final QName SIGNED_ENCRYPTED_SUPPORTING_TOKENS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SignedEncryptedSupportingTokens", "sp");
    public static final QName ENDORSING_ENCRYPTED_SUPPORTING_TOKENS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "EndorsingEncryptedSupportingTokens", "sp");
    public static final QName SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SignedEndorsingEncryptedSupportingTokens", "sp");
    public static final QName PROTECTION_TOKEN = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "ProtectionToken", "sp");
    public static final QName ASYMMETRIC_BINDING = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "AsymmetricBinding", "sp");
    public static final QName SYMMETRIC_BINDING = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SymmetricBinding", "sp");
    public static final QName INITIATOR_TOKEN = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "InitiatorToken", "sp");
    public static final QName RECIPIENT_TOKEN = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RecipientToken", "sp");
    public static final QName ENCRYPT_SIGNATURE = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "EncryptSignature", "sp");
    public static final QName PROTECT_TOKENS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "ProtectTokens", "sp");
    public static final QName REQUIRE_KEY_IDENTIFIER_REFERENCE = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireKeyIdentifierReference", "sp");
    public static final QName REQUIRE_ISSUER_SERIAL_REFERENCE = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireIssuerSerialReference", "sp");
    public static final QName REQUIRE_EMBEDDED_TOKEN_REFERENCE = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireEmbeddedTokenReference", "sp");
    public static final QName REQUIRE_THUMBPRINT_REFERENCE = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireThumbprintReference", "sp");
    public static final QName MUST_SUPPORT_REF_KEY_IDENTIFIER = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustSupportRefKeyIdentifier", "sp");
    public static final QName MUST_SUPPORT_REF_ISSUER_SERIAL = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustSupportRefIssuerSerial", "sp");
    public static final QName MUST_SUPPORT_REF_EXTERNAL_URI = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustSupportRefExternalURI", "sp");
    public static final QName MUST_SUPPORT_REF_EMBEDDED_TOKEN = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustSupportRefEmbeddedToken", "sp");
    public static final QName MUST_SUPPORT_REF_THUMBPRINT = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustSupportRefThumbprint", "sp");
    public static final QName MUST_SUPPORT_REF_ENCRYPTED_KEY = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustSupportRefEncryptedKey", "sp");
    public static final QName WSS10 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Wss10", "sp");
    public static final QName WSS11 = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Wss11", "sp");
    public static final QName REQUIRE_SIGNATURE_CONFIRMATION = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireSignatureConfirmation", "sp");
    public static final QName MUST_SUPPORT_CLIENT_CHALLENGE = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustSupportClientChanllenge", "sp");
    public static final QName MUST_SUPPORT_SERVER_CHALLENGE = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustSupportServerChanllenge", "sp");
    public static final QName REQUIRE_CLIENT_ENTROPY = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireClientEntropy", "sp");
    public static final QName REQUIRE_SERVER_ENTROPY = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireServerEntropy", "sp");
    public static final QName MUST_SUPPORT_ISSUED_TOKENS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "MustSupportIssuedTokens", "sp");
    public static final QName REQUIRE_REQUEST_SECURITY_TOKEN_COLLECTION = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireRequestSecurityTokenCollection", "sp");
    public static final QName REQUIRE_APPLIES_TO = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireAppliesTo", "sp");
    public static final QName ISSUER = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Issuer", "sp");
    public static final QName REQUIRE_DERIVED_KEYS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireDerivedKeys", "sp");
    public static final QName REQUIRE_IMPLIED_DERIVED_KEYS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireImpliedDerivedKeys", "sp");
    public static final QName REQUIRE_EXPLICIT_DERIVED_KEYS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireExplicitDerivedKeys", "sp");
    public static final QName REQUIRE_EXTERNAL_URI_REFERENCE = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireExternalUriReference", "sp");
    public static final QName REQUIRE_EXTERNAL_REFERENCE = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireExternalReference", "sp");
    public static final QName REQUIRE_INTERNAL_REFERENCE = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequireInternalReference", "sp");
    public static final QName REQUEST_SECURITY_TOKEN_TEMPLATE = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "RequestSecurityTokenTemplate", "sp");
    public static final QName SC10_SECURITY_CONTEXT_TOKEN = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SC10SecurityContextToken", "sp");
    public static final QName BOOTSTRAP_POLICY = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "BootstrapPolicy", "sp");
    public static final QName XPATH = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "XPath", "sp");
    public static final QName NO_PASSWORD = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "NoPassword", "sp");
    public static final QName HASH_PASSWORD = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "HashPassword", "sp");
    public static final QName ATTACHMENTS = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "Attachments");

    private SP12Constants() {
    }

    public SPConstants.IncludeTokenType getInclusionFromAttributeValue(String value) {
        if (INCLUDE_ALWAYS.equals(value)) {
            return SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS;
        }
        if (INCLUDE_ALWAYS_TO_RECIPIENT.equals(value)) {
            return SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT;
        }
        if (INCLUDE_ALWAYS_TO_INITIATOR.equals(value)) {
            return SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_INITIATOR;
        }
        if (INCLUDE_NEVER.equals(value)) {
            return SPConstants.IncludeTokenType.INCLUDE_TOKEN_NEVER;
        }
        if (INCLUDE_ONCE.equals(value)) {
            return SPConstants.IncludeTokenType.INCLUDE_TOKEN_ONCE;
        }
        return StringUtils.isEmpty(value) ? SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS : null;
    }

    public String getAttributeValueFromInclusion(SPConstants.IncludeTokenType value) {
        switch (value) {
            case INCLUDE_TOKEN_ALWAYS: {
                return INCLUDE_ALWAYS;
            }
            case INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT: {
                return INCLUDE_ALWAYS_TO_RECIPIENT;
            }
            case INCLUDE_TOKEN_ALWAYS_TO_INITIATOR: {
                return INCLUDE_ALWAYS_TO_INITIATOR;
            }
            case INCLUDE_TOKEN_NEVER: {
                return INCLUDE_NEVER;
            }
            case INCLUDE_TOKEN_ONCE: {
                return INCLUDE_ONCE;
            }
        }
        return null;
    }

    public SPConstants.Version getVersion() {
        return SPConstants.Version.SP_V12;
    }

    public String getNamespace() {
        return SP_NS;
    }

    public QName getWSS10() {
        return WSS10;
    }

    public QName getWSS11() {
        return WSS11;
    }

    public QName getAlgorithmSuite() {
        return ALGORITHM_SUITE;
    }

    public QName getAsymmetricBinding() {
        return ASYMMETRIC_BINDING;
    }

    public QName getEncryptionToken() {
        return ENCRYPTION_TOKEN;
    }

    public QName getHttpsToken() {
        return HTTPS_TOKEN;
    }

    public QName getInitiatorToken() {
        return INITIATOR_TOKEN;
    }

    public QName getIssuedToken() {
        return ISSUED_TOKEN;
    }

    public QName getLayout() {
        return LAYOUT;
    }

    public QName getProtectionToken() {
        return PROTECTION_TOKEN;
    }

    public QName getRecipientToken() {
        return RECIPIENT_TOKEN;
    }

    public QName getRequiredElements() {
        return REQUIRED_ELEMENTS;
    }

    public QName getSecureConversationToken() {
        return SECURE_CONVERSATION_TOKEN;
    }

    public QName getSecurityContextToken() {
        return SECURITY_CONTEXT_TOKEN;
    }

    public QName getSignatureToken() {
        return SIGNATURE_TOKEN;
    }

    public QName getSignedElements() {
        return SIGNED_ELEMENTS;
    }

    public QName getEncryptedElements() {
        return ENCRYPTED_ELEMENTS;
    }

    public QName getSignedParts() {
        return SIGNED_PARTS;
    }

    public QName getEncryptedParts() {
        return ENCRYPTED_PARTS;
    }

    public QName getSymmetricBinding() {
        return SYMMETRIC_BINDING;
    }

    public QName getTransportBinding() {
        return TRANSPORT_BINDING;
    }

    public QName getTransportToken() {
        return TRANSPORT_TOKEN;
    }

    public QName getUserNameToken() {
        return USERNAME_TOKEN;
    }

    public QName getKeyValueToken() {
        return KEYVALUE_TOKEN;
    }

    public QName getX509Token() {
        return X509_TOKEN;
    }

    public QName getSupportingTokens() {
        return SUPPORTING_TOKENS;
    }

    public QName getSignedSupportingTokens() {
        return SIGNED_SUPPORTING_TOKENS;
    }

    public QName getEndorsingSupportingTokens() {
        return ENDORSING_SUPPORTING_TOKENS;
    }

    public QName getSignedEndorsingSupportingTokens() {
        return SIGNED_ENDORSING_SUPPORTING_TOKENS;
    }

    public QName getIncludeToken() {
        return INCLUDE_TOKEN;
    }

    public QName getRequiredDerivedKeys() {
        return REQUIRE_DERIVED_KEYS;
    }

    public QName getIncludeTimestamp() {
        return INCLUDE_TIMESTAMP;
    }
}

