/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.naming.url;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLFactory
implements ObjectFactory {
    protected static final String FACTORY_TYPE = "java.net.URL";

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws NamingException {
        Reference ref = (Reference)obj;
        String clname = ref.getClassName();
        if (!ref.getClassName().equals(FACTORY_TYPE)) {
            throw new NamingException("Cannot create object : required type is 'java.net.URL', but found type is '" + clname + "'.");
        }
        URL url = null;
        String urlString = (String)ref.get("url").getContent();
        if (urlString != null) {
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                NamingException ne = new NamingException("Cannot build an URL with the given string '" + urlString + "'");
                ne.initCause(e);
                throw ne;
            }
        } else {
            throw new NamingException("Can not build an object as no URL was given.");
        }
        return url;
    }
}

