/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler.modules;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.modules.ModelerSource;

public class MbeansDescriptorsSerSource
extends ModelerSource {
    private static final Log log = LogFactory.getLog(MbeansDescriptorsSerSource.class);
    Registry registry;
    String location;
    String type;
    Object source;
    List<ObjectName> mbeans = new ArrayList<ObjectName>();

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public void setLocation(String loc) {
        this.location = loc;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    @Override
    public List<ObjectName> loadDescriptors(Registry registry, String location, String type, Object source) throws Exception {
        this.setRegistry(registry);
        this.setLocation(location);
        this.setType(type);
        this.setSource(source);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry(null, null);
        }
        long t1 = System.currentTimeMillis();
        try {
            InputStream stream = null;
            if (this.source instanceof URL) {
                stream = ((URL)this.source).openStream();
            }
            if (this.source instanceof InputStream) {
                stream = (InputStream)this.source;
            }
            if (stream == null) {
                throw new Exception("Can't process " + this.source);
            }
            ObjectInputStream ois = new ObjectInputStream(stream);
            Thread.currentThread().setContextClassLoader(ManagedBean.class.getClassLoader());
            Object obj = ois.readObject();
            ManagedBean[] beans = (ManagedBean[])obj;
            for (int i = 0; i < beans.length; ++i) {
                this.registry.addManagedBean(beans[i]);
            }
        }
        catch (Exception ex) {
            log.error("Error reading descriptors " + this.source + " " + ex.toString(), ex);
            throw ex;
        }
        long t2 = System.currentTimeMillis();
        log.info("Reading descriptors ( ser ) " + (t2 - t1));
    }
}

