/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.StringId;
import fr.dyade.aaa.common.Pool;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.objectweb.util.monolog.api.BasicLevel;

final class Message
implements Serializable {
    static final long serialVersionUID = 1L;
    transient AgentId from;
    transient AgentId to;
    transient Notification not;
    transient short source;
    transient short dest;
    transient int stamp;
    static final int LENGTH = 25;
    static final byte NULL = 0;
    static final byte NOTNULL = 64;
    static final byte PERSISTENT = 1;
    static final byte DETACHABLE = 2;
    private transient String stringId = null;
    private static Pool pool = null;

    short getSource() {
        return this.source;
    }

    short getDest() {
        return this.dest;
    }

    int getStamp() {
        return this.stamp;
    }

    public String toString() {
        return this.appendToString(new StringBuffer()).toString();
    }

    public StringBuffer appendToString(StringBuffer strbuf) {
        strbuf.append('(').append(super.toString());
        strbuf.append(",from=").append(this.from);
        strbuf.append(",to=").append(this.to);
        strbuf.append(",not=").append(this.not);
        strbuf.append(",source=").append(this.source);
        strbuf.append(",dest=").append(this.dest);
        strbuf.append(",stamp=").append(this.stamp);
        strbuf.append(')');
        return strbuf;
    }

    byte optToByte() {
        if (this.not != null) {
            return (byte)(0x40 | (this.not.persistent ? 1 : 0) | (this.not.detachable ? 2 : 0));
        }
        return 0;
    }

    void optFromByte(byte opt) {
        if (this.not != null) {
            this.not.persistent = (opt & 1) != 0;
            this.not.detachable = (opt & 2) != 0;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeShort(this.from.from);
        out.writeShort(this.from.to);
        out.writeInt(this.from.stamp);
        out.writeShort(this.to.from);
        out.writeShort(this.to.to);
        out.writeInt(this.to.stamp);
        out.writeShort(this.source);
        out.writeShort(this.dest);
        out.writeInt(this.stamp);
        if (this.not == null) {
            Debug.getLogger((String)this.getClass().getName()).log(BasicLevel.ERROR, (Object)"Message.writeObject() -> null notification.");
            out.write(0);
        } else {
            out.write(this.optToByte());
            if (!this.not.detachable) {
                out.writeObject(this.not);
            } else {
                Debug.getLogger((String)this.getClass().getName()).log(BasicLevel.DEBUG, (Object)("Message.writeObject() -> detachable notification: " + this.not));
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.from = new AgentId(in.readShort(), in.readShort(), in.readInt());
        this.to = new AgentId(in.readShort(), in.readShort(), in.readInt());
        this.source = in.readShort();
        this.dest = in.readShort();
        this.stamp = in.readInt();
        int opt = in.read();
        if (opt == 0) {
            Debug.getLogger((String)this.getClass().getName()).log(BasicLevel.ERROR, (Object)"Message.readObject -> null notification.");
            this.not = null;
        } else {
            boolean detachable;
            boolean persistent = (opt & 1) != 0;
            boolean bl = detachable = (opt & 2) != 0;
            if (!detachable) {
                this.not = (Notification)in.readObject();
                this.not.detachable = detachable;
                this.not.persistent = persistent;
                this.not.detached = false;
            } else {
                Debug.getLogger((String)this.getClass().getName()).log(BasicLevel.DEBUG, (Object)("Message.readObject -> " + opt));
            }
        }
    }

    final String toStringId() {
        if (this.stringId == null) {
            this.stringId = StringId.toStringId('@', '_', this.dest, this.stamp, -1);
        }
        return this.stringId;
    }

    boolean isPersistent() {
        return this.not != null && this.not.persistent;
    }

    void save() throws IOException {
        if (this.isPersistent()) {
            AgentServer.getTransaction().create(this, this.toStringId());
            if (this.not.detachable) {
                this.not.messageId = StringId.toStringId('N', '_', this.dest, this.stamp, -1);
                AgentServer.getTransaction().create(this.not, this.not.messageId);
            }
        }
    }

    static Message load(String name) throws IOException, ClassNotFoundException {
        Message msg = (Message)AgentServer.getTransaction().load(name);
        if (msg.not == null) {
            String messageId = StringId.toStringId('N', '_', msg.dest, msg.stamp, -1);
            msg.not = (Notification)AgentServer.getTransaction().load(messageId);
            msg.not.messageId = messageId;
            msg.not.detachable = true;
            msg.not.detached = false;
        }
        msg.not.persistent = true;
        return msg;
    }

    void delete() {
        if (this.isPersistent()) {
            AgentServer.getTransaction().delete(this.toStringId());
            if (this.not != null && this.not.detachable && !this.not.detached) {
                AgentServer.getTransaction().delete(this.not.getMessageId());
            }
        }
    }

    private Message() {
    }

    static Message alloc() {
        Message msg = null;
        try {
            msg = (Message)pool.allocElement();
        }
        catch (Exception exc) {
            return new Message();
        }
        return msg;
    }

    static Message alloc(AgentId from, AgentId to, Notification not) {
        Message msg = Message.alloc();
        msg.set(from, to, not);
        return msg;
    }

    void free() {
        this.not = null;
        this.stringId = null;
        pool.freeElement((Object)this);
    }

    private void set(AgentId from, AgentId to, Notification not) {
        this.from = from;
        this.to = to;
        if (not != null) {
            this.not = (Notification)not.clone();
            this.not.detached = not.detached;
            this.not.messageId = not.messageId;
        }
    }

    static {
        int size = AgentServer.getInteger("fr.dyade.aaa.agent.Message$Pool.size", 150);
        pool = new Pool("Message", size);
    }
}

