/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.ManagementStrategy;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Managed ThreadPool")
public class ManagedThreadPool {
    private final CamelContext camelContext;
    private final ThreadPoolExecutor threadPool;

    public ManagedThreadPool(CamelContext camelContext, ThreadPoolExecutor threadPool) {
        this.camelContext = camelContext;
        this.threadPool = threadPool;
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getContext() {
        return this.camelContext;
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    @ManagedAttribute(description="Core pool size")
    public int getCorePoolSize() {
        return this.threadPool.getCorePoolSize();
    }

    @ManagedAttribute(description="Core pool size")
    public void setCorePoolSize(int corePoolSize) {
        this.threadPool.setCorePoolSize(corePoolSize);
    }

    @ManagedAttribute(description="Pool size")
    public int getPoolSize() {
        return this.threadPool.getPoolSize();
    }

    @ManagedAttribute(description="Maximum pool size")
    public int getMaximumPoolSize() {
        return this.threadPool.getMaximumPoolSize();
    }

    @ManagedAttribute(description="Maximum pool size")
    public void setMaximumPoolSize(int maximumPoolSize) {
        this.threadPool.setMaximumPoolSize(maximumPoolSize);
    }

    @ManagedAttribute(description="Largest pool size")
    public int getLargestPoolSize() {
        return this.threadPool.getLargestPoolSize();
    }

    @ManagedAttribute(description="Active count")
    public int getActiveCount() {
        return this.threadPool.getActiveCount();
    }

    @ManagedAttribute(description="Task count")
    public long getTaskCount() {
        return this.threadPool.getTaskCount();
    }

    @ManagedAttribute(description="Completed task count")
    public long getCompletedTaskCount() {
        return this.threadPool.getCompletedTaskCount();
    }

    @ManagedAttribute(description="Keep alive time in seconds")
    public long getKeepAliveTime() {
        return this.threadPool.getKeepAliveTime(TimeUnit.SECONDS);
    }

    @ManagedAttribute(description="Keep alive time in seconds")
    public void setKeepAliveTime(int keepAliveTimeInSeconds) {
        this.threadPool.setKeepAliveTime(keepAliveTimeInSeconds, TimeUnit.SECONDS);
    }

    @ManagedAttribute(description="Is shutdown")
    public boolean isShutdown() {
        return this.threadPool.isShutdown();
    }
}

