/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.monitoring;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.Strings;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class DumpAttributes {
    public static Logger logger = Debug.getLogger(DumpAttributes.class.getName());

    static void addRecord(StringBuffer strbuf, ObjectName mbean, String att, Object value) {
        strbuf.append(mbean).append(':').append(att).append('=');
        Strings.toString(strbuf, value);
        strbuf.append('\n');
    }

    public static void dumpAttributes(String name, String path) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(path, true);
        }
        catch (IOException exc) {
            logger.log(BasicLevel.ERROR, (Object)("FileMonitoringTimerTask.<init>, cannot open file \"" + path + "\""), (Throwable)exc);
        }
        StringBuffer strbuf = new StringBuffer();
        Set mBeans = null;
        try {
            mBeans = MXWrapper.queryNames(new ObjectName(name));
        }
        catch (MalformedObjectNameException exc) {
            logger.log(BasicLevel.ERROR, (Object)("DumpAttributes.dumpAttributes, bad name: " + name), (Throwable)exc);
        }
        if (mBeans != null) {
            for (ObjectName mBean : mBeans) {
                try {
                    MBeanAttributeInfo[] attributes = MXWrapper.getAttributes(mBean);
                    if (attributes != null) {
                        for (int i = 0; i < attributes.length; ++i) {
                            String attname = attributes[i].getName();
                            try {
                                DumpAttributes.addRecord(strbuf, mBean, attname, MXWrapper.getAttribute(mBean, attname));
                                continue;
                            }
                            catch (Exception exc) {
                                logger.log(BasicLevel.ERROR, (Object)("DumpAttributes.dumpAttributes, bad attribute : " + mBean + ":" + attname), (Throwable)exc);
                            }
                        }
                    }
                    writer.write(strbuf.toString());
                    strbuf.setLength(0);
                }
                catch (Exception exc) {
                    logger.log(BasicLevel.ERROR, (Object)"DumpAttributes.dumpAttributes", (Throwable)exc);
                }
            }
        }
    }
}

