/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.hsqldb;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.hsqldb.DatabaseManager;
import org.hsqldb.Server;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.hsqldb.User;
import org.ow2.easybeans.component.itf.EmbeddedDBComponent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSQLDBComponent
implements EmbeddedDBComponent {
    private static Log logger = LogFactory.getLog(HSQLDBComponent.class);
    private List<User> users = null;
    private String databaseName = null;
    private static final String DEFAULT_PORT = "9001";
    private static final String DEFAULT_HOST = "localhost";
    private static final int SLEEP_VALUE = 100;
    private static final int MAX_RETRY_NB = 20;
    private String portNumber = "9001";
    private String hostname = "localhost";
    private Server server = null;
    private String path = null;

    public void init() throws EZBComponentException {
        this.server = new Server();
        if (!logger.isDebugEnabled()) {
            this.server.setLogWriter(null);
            this.server.setErrWriter(null);
            this.server.setSilent(true);
            this.server.setTrace(false);
            this.server.setLogWriter(null);
        } else {
            this.server.setSilent(false);
            this.server.setTrace(true);
        }
        String baseDir = null;
        baseDir = this.path != null ? this.path + File.separator + this.databaseName : System.getProperty("java.io.tmpdir") + File.separator + "easybeans" + File.separator + "hsqldb" + File.separator + this.databaseName;
        String pString = "";
        if (this.portNumber != null) {
            pString = ";port=" + this.portNumber;
        }
        String serverProps = "database.0=" + baseDir + ";dbname.0=" + this.databaseName + pString;
        logger.debug((Object)"Server properties = {0}", new Object[]{serverProps});
        this.server.putPropertiesFromString(serverProps);
        this.server.setAddress(this.hostname);
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (ClassNotFoundException e) {
            throw new EZBComponentException("Cannot access to HSQL Driver 'org.hsqldb.jdbcDriver'.", (Throwable)e);
        }
    }

    public void start() throws EZBComponentException {
        logger.info((Object)"Starting ''{0}'' ''{1}'' on port ''{2}''", new Object[]{this.server.getProductName(), this.server.getProductVersion(), this.portNumber});
        this.server.start();
        int retryNb = 0;
        while (this.server.getState() != 1) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                logger.error((Object)"Cannot wait that the service is online", new Object[]{ie});
            }
            if (this.server.getState() == 16 && ++retryNb >= 20) {
                Throwable t = this.server.getServerError();
                throw new EZBComponentException("Cannot start the server. The server has not started and is shutdown.", t);
            }
            logger.debug((Object)"retry= {0}, serverState= {1}", new Object[]{retryNb, this.server.getState()});
        }
        String connURL = "jdbc:hsqldb:hsql://" + this.hostname + ":" + this.portNumber + "/" + this.databaseName;
        logger.info((Object)"{0} started with URL {1}", new Object[]{this.server.getProductName(), connURL});
        Connection conn = null;
        Statement st = null;
        try {
            conn = DriverManager.getConnection(connURL, "sa", "");
        }
        catch (SQLException e) {
            throw new EZBComponentException("Cannot access to HSQL", (Throwable)e);
        }
        try {
            st = conn.createStatement();
        }
        catch (SQLException e) {
            try {
                conn.close();
            }
            catch (SQLException connEx) {
                logger.error((Object)"Error while closing connection object", new Object[]{connEx});
            }
            throw new EZBComponentException("Cannot access to HSQL", (Throwable)e);
        }
        User user2 = null;
        String userName = null;
        String password = null;
        ResultSet rs = null;
        for (User user2 : this.users) {
            try {
                password = user2.getPassword();
                userName = user2.getUserName();
                logger.debug((Object)"Dropping and adding user {0} with password {1}.", new Object[]{userName, password});
                try {
                    rs = st.executeQuery("DROP USER " + userName);
                }
                catch (SQLException e) {
                    logger.debug((Object)"User {0} doesn't exists", new Object[]{userName, e});
                }
                rs = st.executeQuery("Create USER " + userName + " PASSWORD " + password + " ADMIN");
                rs.close();
            }
            catch (SQLException e) {
                logger.error((Object)"Error while creating/adding user", new Object[]{e});
            }
        }
        try {
            st.close();
            conn.close();
        }
        catch (SQLException e) {
            logger.error((Object)"Error while closing statement object", new Object[]{e});
        }
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public void stop() throws EZBComponentException {
        this.server.shutdown();
        DatabaseManager.getTimer().shutDown();
    }

    public void setPortNumber(String portNumber) {
        this.portNumber = portNumber;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

