/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Component;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesResolver;
import org.apache.camel.management.DefaultManagementAgent;
import org.apache.camel.management.DefaultManagementLifecycleStrategy;
import org.apache.camel.management.DefaultManagementStrategy;
import org.apache.camel.management.ManagedManagementStrategy;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PackageScanDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteBuilderDefinition;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteContextRefDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ThreadPoolProfileDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.model.config.PropertiesDefinition;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.processor.interceptor.Delayer;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ExecutorServiceStrategy;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.CamelConsumerTemplateFactoryBean;
import org.apache.camel.spring.CamelEndpointFactoryBean;
import org.apache.camel.spring.CamelJMXAgentDefinition;
import org.apache.camel.spring.CamelProducerTemplateFactoryBean;
import org.apache.camel.spring.CamelPropertyPlaceholderDefinition;
import org.apache.camel.spring.CamelProxyFactoryDefinition;
import org.apache.camel.spring.CamelServiceExporterDefinition;
import org.apache.camel.spring.CamelThreadPoolFactoryBean;
import org.apache.camel.spring.ErrorHandlerDefinition;
import org.apache.camel.spring.PatternBasedPackageScanFilter;
import org.apache.camel.spring.RouteBuilderFinder;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="camelContext")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelContextFactoryBean
extends IdentifiedType
implements RouteContainer,
FactoryBean,
InitializingBean,
DisposableBean,
ApplicationContextAware,
ApplicationListener {
    private static final Log LOG = LogFactory.getLog(CamelContextFactoryBean.class);
    @XmlAttribute(name="depends-on", required=false)
    private String dependsOn;
    @XmlAttribute(required=false)
    private String trace;
    @XmlAttribute(required=false)
    private String streamCache = "false";
    @XmlAttribute(required=false)
    private String delayer;
    @XmlAttribute(required=false)
    private String handleFault;
    @XmlAttribute(required=false)
    private String errorHandlerRef;
    @XmlAttribute(required=false)
    private String autoStartup = "true";
    @XmlAttribute(required=false)
    private ShutdownRoute shutdownRoute;
    @XmlAttribute(required=false)
    private ShutdownRunningTask shutdownRunningTask;
    @XmlElement(name="properties", required=false)
    private PropertiesDefinition properties;
    @XmlElement(name="propertyPlaceholder", type=CamelPropertyPlaceholderDefinition.class, required=false)
    private CamelPropertyPlaceholderDefinition camelPropertyPlaceholder;
    @XmlElement(name="package", required=false)
    private String[] packages = new String[0];
    @XmlElement(name="packageScan", type=PackageScanDefinition.class, required=false)
    private PackageScanDefinition packageScan;
    @XmlElement(name="jmxAgent", type=CamelJMXAgentDefinition.class, required=false)
    private CamelJMXAgentDefinition camelJMXAgent;
    @XmlElements(value={@XmlElement(name="beanPostProcessor", type=CamelBeanPostProcessor.class, required=false), @XmlElement(name="template", type=CamelProducerTemplateFactoryBean.class, required=false), @XmlElement(name="consumerTemplate", type=CamelConsumerTemplateFactoryBean.class, required=false), @XmlElement(name="proxy", type=CamelProxyFactoryDefinition.class, required=false), @XmlElement(name="export", type=CamelServiceExporterDefinition.class, required=false), @XmlElement(name="errorHandler", type=ErrorHandlerDefinition.class, required=false)})
    private List beans;
    @XmlElement(name="routeBuilder", required=false)
    private List<RouteBuilderDefinition> builderRefs = new ArrayList<RouteBuilderDefinition>();
    @XmlElement(name="routeContextRef", required=false)
    private List<RouteContextRefDefinition> routeRefs = new ArrayList<RouteContextRefDefinition>();
    @XmlElement(name="threadPoolProfile", required=false)
    private List<ThreadPoolProfileDefinition> threadPoolProfiles;
    @XmlElement(name="threadPool", required=false)
    private List<CamelThreadPoolFactoryBean> threadPools;
    @XmlElement(name="endpoint", required=false)
    private List<CamelEndpointFactoryBean> endpoints;
    @XmlElement(name="dataFormats", required=false)
    private DataFormatsDefinition dataFormats;
    @XmlElement(name="onException", required=false)
    private List<OnExceptionDefinition> onExceptions = new ArrayList<OnExceptionDefinition>();
    @XmlElement(name="onCompletion", required=false)
    private List<OnCompletionDefinition> onCompletions = new ArrayList<OnCompletionDefinition>();
    @XmlElement(name="intercept", required=false)
    private List<InterceptDefinition> intercepts = new ArrayList<InterceptDefinition>();
    @XmlElement(name="interceptFrom", required=false)
    private List<InterceptFromDefinition> interceptFroms = new ArrayList<InterceptFromDefinition>();
    @XmlElement(name="interceptSendToEndpoint", required=false)
    private List<InterceptSendToEndpointDefinition> interceptSendToEndpoints = new ArrayList<InterceptSendToEndpointDefinition>();
    @XmlElement(name="route", required=false)
    private List<RouteDefinition> routes = new ArrayList<RouteDefinition>();
    @XmlTransient
    private SpringCamelContext context;
    @XmlTransient
    private List<RoutesBuilder> builders = new ArrayList<RoutesBuilder>();
    @XmlTransient
    private ApplicationContext applicationContext;
    @XmlTransient
    private ClassLoader contextClassLoaderOnStart = Thread.currentThread().getContextClassLoader();
    @XmlTransient
    private BeanPostProcessor beanPostProcessor;

    public Object getObject() throws Exception {
        return this.getContext();
    }

    public Class getObjectType() {
        return SpringCamelContext.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public ClassLoader getContextClassLoaderOnStart() {
        return this.contextClassLoaderOnStart;
    }

    public void afterPropertiesSet() throws Exception {
        Map lifecycleStrategies;
        Map interceptStrategies;
        ShutdownStrategy shutdownStrategy;
        Map eventNotifiers;
        EventFactory eventFactory;
        ManagementStrategy managementStrategy;
        Delayer delayer;
        HandleFault handleFault;
        Registry registry;
        ExecutorServiceStrategy executorServiceStrategy;
        FactoryFinderResolver factoryFinderResolver;
        ClassResolver classResolver;
        PackageScanClassResolver packageResolver;
        if (ObjectHelper.isEmpty((Object)this.getId())) {
            throw new IllegalArgumentException("Id must be set");
        }
        if (this.properties != null) {
            this.getContext().setProperties(this.properties.asMap());
        }
        if ((packageResolver = this.getBeanForType(PackageScanClassResolver.class)) != null) {
            LOG.info((Object)("Using custom PackageScanClassResolver: " + packageResolver));
            this.getContext().setPackageScanClassResolver(packageResolver);
        }
        if ((classResolver = this.getBeanForType(ClassResolver.class)) != null) {
            LOG.info((Object)("Using custom ClassResolver: " + classResolver));
            this.getContext().setClassResolver(classResolver);
        }
        if ((factoryFinderResolver = this.getBeanForType(FactoryFinderResolver.class)) != null) {
            LOG.info((Object)("Using custom FactoryFinderResolver: " + factoryFinderResolver));
            this.getContext().setFactoryFinderResolver(factoryFinderResolver);
        }
        if ((executorServiceStrategy = this.getBeanForType(ExecutorServiceStrategy.class)) != null) {
            LOG.info((Object)("Using custom ExecutorServiceStrategy: " + executorServiceStrategy));
            this.getContext().setExecutorServiceStrategy(executorServiceStrategy);
        }
        if ((registry = this.getBeanForType(Registry.class)) != null) {
            LOG.info((Object)("Using custom Registry: " + registry));
            this.getContext().setRegistry(registry);
        }
        this.initPropertyPlaceholder();
        this.initJMXAgent();
        Tracer tracer = this.getBeanForType(Tracer.class);
        if (tracer != null) {
            TraceFormatter formatter = this.getBeanForType(TraceFormatter.class);
            if (formatter != null) {
                tracer.setFormatter(formatter);
            }
            LOG.info((Object)("Using custom Tracer: " + tracer));
            this.getContext().addInterceptStrategy((InterceptStrategy)tracer);
        }
        if ((handleFault = this.getBeanForType(HandleFault.class)) != null) {
            LOG.info((Object)("Using custom HandleFault: " + handleFault));
            this.getContext().addInterceptStrategy((InterceptStrategy)handleFault);
        }
        if ((delayer = this.getBeanForType(Delayer.class)) != null) {
            LOG.info((Object)("Using custom Delayer: " + delayer));
            this.getContext().addInterceptStrategy((InterceptStrategy)delayer);
        }
        InflightRepository inflightRepository = this.getBeanForType(InflightRepository.class);
        if (delayer != null) {
            LOG.info((Object)("Using custom InflightRepository: " + inflightRepository));
            this.getContext().setInflightRepository(inflightRepository);
        }
        if ((managementStrategy = this.getBeanForType(ManagementStrategy.class)) != null) {
            LOG.info((Object)("Using custom ManagementStrategy: " + managementStrategy));
            this.getContext().setManagementStrategy(managementStrategy);
        }
        if ((eventFactory = this.getBeanForType(EventFactory.class)) != null) {
            LOG.info((Object)("Using custom EventFactory: " + eventFactory));
            this.getContext().getManagementStrategy().setEventFactory(eventFactory);
        }
        if ((eventNotifiers = this.getContext().getRegistry().lookupByType(EventNotifier.class)) != null && !eventNotifiers.isEmpty()) {
            for (String id : eventNotifiers.keySet()) {
                EventNotifier notifier = (EventNotifier)eventNotifiers.get(id);
                if (this.getContext().getManagementStrategy().getEventNotifiers().contains(notifier)) continue;
                LOG.info((Object)("Using custom EventNotifier with id: " + id + " and implementation: " + notifier));
                this.getContext().getManagementStrategy().addEventNotifier(notifier);
            }
        }
        if ((shutdownStrategy = this.getBeanForType(ShutdownStrategy.class)) != null) {
            LOG.info((Object)("Using custom ShutdownStrategy: " + shutdownStrategy));
            this.getContext().setShutdownStrategy(shutdownStrategy);
        }
        if ((interceptStrategies = this.getContext().getRegistry().lookupByType(InterceptStrategy.class)) != null && !interceptStrategies.isEmpty()) {
            for (String id : interceptStrategies.keySet()) {
                InterceptStrategy strategy = (InterceptStrategy)interceptStrategies.get(id);
                if (this.getContext().getInterceptStrategies().contains(strategy)) continue;
                LOG.info((Object)("Using custom InterceptStrategy with id: " + id + " and implementation: " + strategy));
                this.getContext().addInterceptStrategy(strategy);
            }
        }
        if ((lifecycleStrategies = this.getContext().getRegistry().lookupByType(LifecycleStrategy.class)) != null && !lifecycleStrategies.isEmpty()) {
            for (String id : lifecycleStrategies.keySet()) {
                LifecycleStrategy strategy = (LifecycleStrategy)lifecycleStrategies.get(id);
                if (this.getContext().getLifecycleStrategies().contains(strategy)) continue;
                LOG.info((Object)("Using custom LifecycleStrategy with id: " + id + " and implementation: " + strategy));
                this.getContext().addLifecycleStrategy(strategy);
            }
        }
        this.initThreadPoolProfiles((CamelContext)this.getContext());
        if (this.beanPostProcessor != null) {
            if (this.beanPostProcessor instanceof ApplicationContextAware) {
                ((ApplicationContextAware)this.beanPostProcessor).setApplicationContext(this.applicationContext);
            }
            if (this.beanPostProcessor instanceof CamelBeanPostProcessor) {
                ((CamelBeanPostProcessor)this.beanPostProcessor).setCamelContext((CamelContext)this.getContext());
            }
        }
        this.initSpringCamelContext(this.getContext());
        this.initRouteRefs();
        for (RouteDefinition route : this.routes) {
            ArrayList<ProcessorDefinition> abstracts = new ArrayList<ProcessorDefinition>();
            ArrayList<ProcessorDefinition> upper = new ArrayList<ProcessorDefinition>();
            ArrayList<ProcessorDefinition> lower = new ArrayList<ProcessorDefinition>();
            this.prepareRouteForInit(route, abstracts, lower);
            this.initToAsync(lower);
            this.initInterceptors(route, upper);
            this.initOnCompletions(abstracts, upper);
            this.initTransacted(abstracts, lower);
            this.initOnExceptions(abstracts, upper);
            route.clearOutput();
            route.getOutputs().addAll(upper);
            route.getOutputs().addAll(lower);
            this.initParent(route);
        }
        if (this.dataFormats != null) {
            this.getContext().setDataFormats(this.dataFormats.asMap());
        }
        this.getContext().addRouteDefinitions(this.routes);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found JAXB created routes: " + this.getRoutes()));
        }
        this.findRouteBuilders();
        this.installRoutes();
    }

    private void prepareRouteForInit(RouteDefinition route, List<ProcessorDefinition> abstracts, List<ProcessorDefinition> lower) {
        for (ProcessorDefinition output : route.getOutputs()) {
            if (output.isAbstract()) {
                abstracts.add(output);
                continue;
            }
            lower.add(output);
        }
    }

    private void initParent(RouteDefinition route) {
        for (ProcessorDefinition output : route.getOutputs()) {
            output.setParent((ProcessorDefinition)route);
            if (output.getOutputs() == null) continue;
            this.initParent(output);
        }
    }

    private void initParent(ProcessorDefinition parent) {
        List children = parent.getOutputs();
        for (ProcessorDefinition child : children) {
            child.setParent(parent);
            if (child.getOutputs() == null) continue;
            this.initParent(child);
        }
    }

    private void initToAsync(List<ProcessorDefinition> lower) {
        ArrayList<ProcessorDefinition> outputs = new ArrayList<ProcessorDefinition>();
        ToDefinition toAsync = null;
        for (ProcessorDefinition output : lower) {
            ToDefinition to;
            if (toAsync != null) {
                toAsync.getOutputs().add(output);
            } else {
                outputs.add(output);
            }
            if (!(output instanceof ToDefinition) || (to = (ToDefinition)output).isAsync() == null || !to.isAsync().booleanValue()) continue;
            toAsync = to;
        }
        lower.clear();
        lower.addAll(outputs);
    }

    private void initOnExceptions(List<ProcessorDefinition> abstracts, List<ProcessorDefinition> upper) {
        if (this.onExceptions != null && !this.onExceptions.isEmpty()) {
            abstracts.addAll(this.onExceptions);
        }
        for (ProcessorDefinition output : abstracts) {
            if (!(output instanceof OnExceptionDefinition)) continue;
            upper.add(0, output);
        }
    }

    private void initInterceptors(RouteDefinition route, List<ProcessorDefinition> upper) {
        for (InterceptDefinition interceptDefinition : this.getIntercepts()) {
            interceptDefinition.afterPropertiesSet();
            upper.add(0, (ProcessorDefinition)interceptDefinition);
        }
        for (InterceptFromDefinition interceptFromDefinition : this.getInterceptFroms()) {
            boolean match = true;
            if (interceptFromDefinition.getUri() != null) {
                match = false;
                for (FromDefinition input : route.getInputs()) {
                    if (!EndpointHelper.matchEndpoint((String)input.getUri(), (String)interceptFromDefinition.getUri())) continue;
                    match = true;
                    break;
                }
            }
            if (!match) continue;
            interceptFromDefinition.afterPropertiesSet();
            upper.add(0, (ProcessorDefinition)interceptFromDefinition);
        }
        for (InterceptSendToEndpointDefinition interceptSendToEndpointDefinition : this.getInterceptSendToEndpoints()) {
            interceptSendToEndpointDefinition.afterPropertiesSet();
            upper.add(0, (ProcessorDefinition)interceptSendToEndpointDefinition);
        }
    }

    private void initOnCompletions(List<ProcessorDefinition> abstracts, List<ProcessorDefinition> upper) {
        List<Object> completions = new ArrayList();
        for (ProcessorDefinition out : abstracts) {
            if (!(out instanceof OnCompletionDefinition)) continue;
            completions.add((OnCompletionDefinition)out);
        }
        if (completions.isEmpty()) {
            completions = this.getOnCompletions();
        }
        if (completions.isEmpty()) {
            return;
        }
        upper.addAll(completions);
    }

    private void initTransacted(List<ProcessorDefinition> abstracts, List<ProcessorDefinition> lower) {
        TransactedDefinition transacted = null;
        for (ProcessorDefinition type : abstracts) {
            if (!(type instanceof TransactedDefinition)) continue;
            if (transacted == null) {
                transacted = (TransactedDefinition)type;
                continue;
            }
            throw new IllegalArgumentException("The route can only have one transacted defined");
        }
        if (transacted != null) {
            transacted.getOutputs().addAll(lower);
            lower.clear();
            lower.add((ProcessorDefinition)transacted);
        }
    }

    private void initJMXAgent() throws Exception {
        if (this.camelJMXAgent != null && this.camelJMXAgent.isAgentDisabled()) {
            LOG.info((Object)"JMXAgent disabled");
            this.getContext().getLifecycleStrategies().clear();
            this.getContext().setManagementStrategy((ManagementStrategy)new DefaultManagementStrategy());
        } else if (this.camelJMXAgent != null) {
            LOG.info((Object)("JMXAgent enabled: " + (Object)((Object)this.camelJMXAgent)));
            DefaultManagementAgent agent = new DefaultManagementAgent((CamelContext)this.getContext());
            agent.setConnectorPort(this.parseInteger(this.camelJMXAgent.getConnectorPort()));
            agent.setCreateConnector(this.parseBoolean(this.camelJMXAgent.getCreateConnector()));
            agent.setMBeanObjectDomainName(this.parseText(this.camelJMXAgent.getMbeanObjectDomainName()));
            agent.setMBeanServerDefaultDomain(this.parseText(this.camelJMXAgent.getMbeanServerDefaultDomain()));
            agent.setRegistryPort(this.parseInteger(this.camelJMXAgent.getRegistryPort()));
            agent.setServiceUrlPath(this.parseText(this.camelJMXAgent.getServiceUrlPath()));
            agent.setUsePlatformMBeanServer(this.parseBoolean(this.camelJMXAgent.getUsePlatformMBeanServer()));
            agent.setOnlyRegisterProcessorWithCustomId(this.parseBoolean(this.camelJMXAgent.getOnlyRegisterProcessorWithCustomId()));
            ManagedManagementStrategy managementStrategy = new ManagedManagementStrategy((ManagementAgent)agent);
            this.getContext().setManagementStrategy((ManagementStrategy)managementStrategy);
            this.getContext().getLifecycleStrategies().clear();
            this.getContext().addLifecycleStrategy((LifecycleStrategy)new DefaultManagementLifecycleStrategy((CamelContext)this.getContext()));
            boolean onlyId = agent.getOnlyRegisterProcessorWithCustomId() != null && agent.getOnlyRegisterProcessorWithCustomId() != false;
            this.getContext().getManagementStrategy().onlyManageProcessorWithCustomId(onlyId);
            this.getContext().getManagementStrategy().setStatisticsLevel(this.camelJMXAgent.getStatisticsLevel());
        }
    }

    private void initPropertyPlaceholder() throws Exception {
        if (this.getCamelPropertyPlaceholder() != null) {
            CamelPropertyPlaceholderDefinition def = this.getCamelPropertyPlaceholder();
            PropertiesComponent pc = new PropertiesComponent();
            pc.setLocation(def.getLocation());
            if (ObjectHelper.isNotEmpty((Object)def.getPropertiesResolverRef())) {
                PropertiesResolver resolver = (PropertiesResolver)CamelContextHelper.mandatoryLookup((CamelContext)this.getContext(), (String)def.getPropertiesResolverRef(), PropertiesResolver.class);
                pc.setPropertiesResolver(resolver);
            }
            this.getContext().addComponent("properties", (Component)pc);
        }
    }

    private void initRouteRefs() throws Exception {
        if (this.routeRefs != null) {
            for (RouteContextRefDefinition ref : this.routeRefs) {
                List defs = ref.lookupRoutes((CamelContext)this.getContext());
                for (RouteDefinition def : defs) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Adding route from " + ref + " -> " + def));
                    }
                    this.routes.add(0, def);
                }
            }
        }
    }

    private <T> T getBeanForType(Class<T> clazz) {
        ApplicationContext parentContext;
        Object bean = null;
        String[] names = this.getApplicationContext().getBeanNamesForType(clazz, true, true);
        if (names.length == 1) {
            bean = this.getApplicationContext().getBean(names[0], clazz);
        }
        if (bean == null && (parentContext = this.getApplicationContext().getParent()) != null && (names = parentContext.getBeanNamesForType(clazz, true, true)).length == 1) {
            bean = parentContext.getBean(names[0], clazz);
        }
        return (T)bean;
    }

    public void destroy() throws Exception {
        this.getContext().stop();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.context != null) {
            this.context.onApplicationEvent(event);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Publishing spring-event: " + event));
            }
            if (event instanceof ContextRefreshedEvent) {
                try {
                    LOG.debug((Object)"Starting the context now!");
                    this.getContext().start();
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
                }
            }
        }
    }

    private String parseText(String text) throws Exception {
        return this.getContext().resolvePropertyPlaceholders(text);
    }

    private Integer parseInteger(String text) throws Exception {
        String s = this.getContext().resolvePropertyPlaceholders(text);
        if (s != null) {
            try {
                return new Integer(s);
            }
            catch (NumberFormatException e) {
                if (s.equals(text)) {
                    throw new IllegalArgumentException("Error parsing [" + s + "] as an Integer.", e);
                }
                throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as an Integer.", e);
            }
        }
        return null;
    }

    private Long parseLong(String text) throws Exception {
        String s = this.getContext().resolvePropertyPlaceholders(text);
        if (s != null) {
            try {
                return new Long(s);
            }
            catch (NumberFormatException e) {
                if (s.equals(text)) {
                    throw new IllegalArgumentException("Error parsing [" + s + "] as a Long.", e);
                }
                throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as a Long.", e);
            }
        }
        return null;
    }

    private Boolean parseBoolean(String text) throws Exception {
        String s = this.getContext().resolvePropertyPlaceholders(text);
        if (s != null) {
            if ((s = s.trim().toLowerCase()).equals("true") || s.equals("false")) {
                return new Boolean(s);
            }
            if (s.equals(text)) {
                throw new IllegalArgumentException("Error parsing [" + s + "] as a Boolean.");
            }
            throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as a Boolean.");
        }
        return null;
    }

    public SpringCamelContext getContext() throws Exception {
        if (this.context == null) {
            this.context = this.createContext();
        }
        return this.context;
    }

    public void setContext(SpringCamelContext context) {
        this.context = context;
    }

    public List<RouteDefinition> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<RouteDefinition> routes) {
        this.routes = routes;
    }

    public List<InterceptDefinition> getIntercepts() {
        return this.intercepts;
    }

    public void setIntercepts(List<InterceptDefinition> intercepts) {
        this.intercepts = intercepts;
    }

    public List<InterceptFromDefinition> getInterceptFroms() {
        return this.interceptFroms;
    }

    public void setInterceptFroms(List<InterceptFromDefinition> interceptFroms) {
        this.interceptFroms = interceptFroms;
    }

    public List<InterceptSendToEndpointDefinition> getInterceptSendToEndpoints() {
        return this.interceptSendToEndpoints;
    }

    public void setInterceptSendToEndpoints(List<InterceptSendToEndpointDefinition> interceptSendToEndpoints) {
        this.interceptSendToEndpoints = interceptSendToEndpoints;
    }

    public ApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            throw new IllegalArgumentException("No applicationContext has been injected!");
        }
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public PropertiesDefinition getProperties() {
        return this.properties;
    }

    public void setProperties(PropertiesDefinition properties) {
        this.properties = properties;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public PackageScanDefinition getPackageScan() {
        return this.packageScan;
    }

    public void setPackageScan(PackageScanDefinition packageScan) {
        this.packageScan = packageScan;
    }

    public CamelPropertyPlaceholderDefinition getCamelPropertyPlaceholder() {
        return this.camelPropertyPlaceholder;
    }

    public void setCamelPropertyPlaceholder(CamelPropertyPlaceholderDefinition camelPropertyPlaceholder) {
        this.camelPropertyPlaceholder = camelPropertyPlaceholder;
    }

    public void setBeanPostProcessor(BeanPostProcessor postProcessor) {
        this.beanPostProcessor = postProcessor;
    }

    public BeanPostProcessor getBeanPostProcessor() {
        return this.beanPostProcessor;
    }

    public void setCamelJMXAgent(CamelJMXAgentDefinition agent) {
        this.camelJMXAgent = agent;
    }

    public String getTrace() {
        return this.trace;
    }

    public void setTrace(String trace) {
        this.trace = trace;
    }

    public String getStreamCache() {
        return this.streamCache;
    }

    public void setStreamCache(String streamCache) {
        this.streamCache = streamCache;
    }

    public String getDelayer() {
        return this.delayer;
    }

    public void setDelayer(String delayer) {
        this.delayer = delayer;
    }

    public String getHandleFault() {
        return this.handleFault;
    }

    public void setHandleFault(String handleFault) {
        this.handleFault = handleFault;
    }

    public String getAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(String autoStartup) {
        this.autoStartup = autoStartup;
    }

    public CamelJMXAgentDefinition getCamelJMXAgent() {
        return this.camelJMXAgent;
    }

    public List<RouteBuilderDefinition> getBuilderRefs() {
        return this.builderRefs;
    }

    public void setBuilderRefs(List<RouteBuilderDefinition> builderRefs) {
        this.builderRefs = builderRefs;
    }

    public List<RouteContextRefDefinition> getRouteRefs() {
        return this.routeRefs;
    }

    public void setRouteRefs(List<RouteContextRefDefinition> routeRefs) {
        this.routeRefs = routeRefs;
    }

    public String getErrorHandlerRef() {
        return this.errorHandlerRef;
    }

    public void setErrorHandlerRef(String errorHandlerRef) {
        this.errorHandlerRef = errorHandlerRef;
    }

    public void setDataFormats(DataFormatsDefinition dataFormats) {
        this.dataFormats = dataFormats;
    }

    public DataFormatsDefinition getDataFormats() {
        return this.dataFormats;
    }

    public void setOnExceptions(List<OnExceptionDefinition> onExceptions) {
        this.onExceptions = onExceptions;
    }

    public List<OnExceptionDefinition> getOnExceptions() {
        return this.onExceptions;
    }

    public List<OnCompletionDefinition> getOnCompletions() {
        return this.onCompletions;
    }

    public void setOnCompletions(List<OnCompletionDefinition> onCompletions) {
        this.onCompletions = onCompletions;
    }

    public ShutdownRoute getShutdownRoute() {
        return this.shutdownRoute;
    }

    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    public ShutdownRunningTask getShutdownRunningTask() {
        return this.shutdownRunningTask;
    }

    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    public List<ThreadPoolProfileDefinition> getThreadPoolProfiles() {
        return this.threadPoolProfiles;
    }

    public void setThreadPoolProfiles(List<ThreadPoolProfileDefinition> threadPoolProfiles) {
        this.threadPoolProfiles = threadPoolProfiles;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String dependsOn) {
        this.dependsOn = dependsOn;
    }

    protected SpringCamelContext createContext() {
        SpringCamelContext ctx = this.newCamelContext();
        ctx.setName(this.getId());
        return ctx;
    }

    protected void initSpringCamelContext(SpringCamelContext ctx) throws Exception {
        if (this.streamCache != null) {
            ctx.setStreamCaching(this.parseBoolean(this.getStreamCache()));
        }
        if (this.trace != null) {
            ctx.setTracing(this.parseBoolean(this.getTrace()));
        }
        if (this.delayer != null) {
            ctx.setDelayer(this.parseLong(this.getDelayer()));
        }
        if (this.handleFault != null) {
            ctx.setHandleFault(this.parseBoolean(this.getHandleFault()));
        }
        if (this.errorHandlerRef != null) {
            ctx.setErrorHandlerBuilder((ErrorHandlerBuilder)new ErrorHandlerBuilderRef(this.getErrorHandlerRef()));
        }
        if (this.autoStartup != null) {
            ctx.setAutoStartup(this.parseBoolean(this.getAutoStartup()));
        }
        if (this.shutdownRoute != null) {
            ctx.setShutdownRoute(this.getShutdownRoute());
        }
        if (this.shutdownRunningTask != null) {
            ctx.setShutdownRunningTask(this.getShutdownRunningTask());
        }
    }

    protected SpringCamelContext newCamelContext() {
        return new SpringCamelContext(this.getApplicationContext());
    }

    private void initThreadPoolProfiles(CamelContext context) {
        HashSet<String> defaultIds = new HashSet<String>();
        Map profiles = context.getRegistry().lookupByType(ThreadPoolProfile.class);
        if (profiles != null && !profiles.isEmpty()) {
            for (String id : profiles.keySet()) {
                ThreadPoolProfile profile = (ThreadPoolProfile)profiles.get(id);
                if (profile.isDefaultProfile().booleanValue()) {
                    LOG.info((Object)("Using custom default ThreadPoolProfile with id: " + id + " and implementation: " + profile));
                    context.getExecutorServiceStrategy().setDefaultThreadPoolProfile(profile);
                    defaultIds.add(id);
                    continue;
                }
                context.getExecutorServiceStrategy().registerThreadPoolProfile(profile);
            }
        }
        if (this.threadPoolProfiles != null && !this.threadPoolProfiles.isEmpty()) {
            for (ThreadPoolProfileDefinition profile : this.threadPoolProfiles) {
                if (profile.isDefaultProfile().booleanValue()) {
                    LOG.info((Object)("Using custom default ThreadPoolProfile with id: " + profile.getId() + " and implementation: " + profile));
                    context.getExecutorServiceStrategy().setDefaultThreadPoolProfile((ThreadPoolProfile)profile);
                    defaultIds.add(profile.getId());
                    continue;
                }
                context.getExecutorServiceStrategy().registerThreadPoolProfile((ThreadPoolProfile)profile);
            }
        }
        if (defaultIds.size() > 1) {
            throw new IllegalArgumentException("Only exactly one default ThreadPoolProfile is allowed, was " + defaultIds.size() + " ids: " + defaultIds);
        }
    }

    protected void installRoutes() throws Exception {
        ArrayList<RouteBuilder> builders = new ArrayList<RouteBuilder>();
        if (this.builderRefs != null) {
            for (RouteBuilderDefinition builderRef : this.builderRefs) {
                RouteBuilder builder = builderRef.createRouteBuilder((CamelContext)this.getContext());
                if (builder != null) {
                    builders.add(builder);
                    continue;
                }
                RoutesBuilder routes = builderRef.createRoutes((CamelContext)this.getContext());
                if (routes != null) {
                    this.builders.add(routes);
                    continue;
                }
                throw new CamelException("Cannot find any routes with this RouteBuilder reference: " + builderRef);
            }
        }
        for (RoutesBuilder routeBuilder : this.builders) {
            this.getContext().addRoutes(routeBuilder);
        }
        for (RouteBuilder builder : builders) {
            if (this.beanPostProcessor != null) {
                this.beanPostProcessor.postProcessBeforeInitialization((Object)builder, builder.toString());
            }
            this.getContext().addRoutes((RoutesBuilder)builder);
        }
    }

    protected void findRouteBuilders() throws Exception {
        PackageScanClassResolver resolver = this.getContext().getPackageScanClassResolver();
        this.addPackageElementContentsToScanDefinition();
        PackageScanDefinition packageScanDef = this.getPackageScan();
        if (packageScanDef != null && packageScanDef.getPackages().size() > 0) {
            PatternBasedPackageScanFilter filter = new PatternBasedPackageScanFilter();
            for (String include : packageScanDef.getIncludes()) {
                include = this.getContext().resolvePropertyPlaceholders(include);
                filter.addIncludePattern(include);
            }
            for (String exclude : packageScanDef.getExcludes()) {
                exclude = this.getContext().resolvePropertyPlaceholders(exclude);
                filter.addExcludePattern(exclude);
            }
            resolver.addFilter((PackageScanFilter)filter);
            String[] normalized = this.normalizePackages((CamelContext)this.getContext(), packageScanDef.getPackages());
            RouteBuilderFinder finder = new RouteBuilderFinder(this.getContext(), normalized, this.getContextClassLoaderOnStart(), this.getBeanPostProcessor(), this.getContext().getPackageScanClassResolver());
            finder.appendBuilders(this.builders);
        }
    }

    private void addPackageElementContentsToScanDefinition() {
        PackageScanDefinition packageScanDef = this.getPackageScan();
        if (this.getPackages() != null && this.getPackages().length > 0) {
            if (packageScanDef == null) {
                packageScanDef = new PackageScanDefinition();
                this.setPackageScan(packageScanDef);
            }
            for (String pkg : this.getPackages()) {
                packageScanDef.getPackages().add(pkg);
            }
        }
    }

    private String[] normalizePackages(CamelContext context, List<String> unnormalized) throws Exception {
        ArrayList<String> packages = new ArrayList<String>();
        for (String name : unnormalized) {
            name = context.resolvePropertyPlaceholders(name);
            if (!ObjectHelper.isNotEmpty((Object)(name = ObjectHelper.normalizeClassName((String)name)))) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Using package: " + name + " to scan for RouteBuilder classes"));
            }
            packages.add(name);
        }
        return packages.toArray(new String[packages.size()]);
    }
}

