/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.xml.security.Init;

public class I18n {
    public static final String NOT_INITIALIZED_MSG = "You must initialize the xml-security library correctly before you use it. Call the static method \"org.apache.xml.security.Init.init();\" to do that before you use any functionality from that library.";
    public static String defaultLanguageCode;
    public static String defaultCountryCode;
    protected static ResourceBundle resourceBundle;
    protected static boolean alreadyInitialized;
    protected static String _languageCode;
    protected static String _countryCode;

    private I18n() {
    }

    public static String translate(String string, Object[] objectArray) {
        return I18n.getExceptionMessage(string, objectArray);
    }

    public static String translate(String string) {
        return I18n.getExceptionMessage(string);
    }

    public static String getExceptionMessage(String string) {
        try {
            String string2 = resourceBundle.getString(string);
            return string2;
        }
        catch (Throwable throwable) {
            if (Init.isInitialized()) {
                return "No message with ID \"" + string + "\" found in resource bundle \"" + "org/apache/xml/security/resource/xmlsecurity" + "\"";
            }
            return NOT_INITIALIZED_MSG;
        }
    }

    public static String getExceptionMessage(String string, Exception exception) {
        try {
            Object[] objectArray = new Object[]{exception.getMessage()};
            String string2 = MessageFormat.format(resourceBundle.getString(string), objectArray);
            return string2;
        }
        catch (Throwable throwable) {
            if (Init.isInitialized()) {
                return "No message with ID \"" + string + "\" found in resource bundle \"" + "org/apache/xml/security/resource/xmlsecurity" + "\". Original Exception was a " + exception.getClass().getName() + " and message " + exception.getMessage();
            }
            return NOT_INITIALIZED_MSG;
        }
    }

    public static String getExceptionMessage(String string, Object[] objectArray) {
        try {
            String string2 = MessageFormat.format(resourceBundle.getString(string), objectArray);
            return string2;
        }
        catch (Throwable throwable) {
            if (Init.isInitialized()) {
                return "No message with ID \"" + string + "\" found in resource bundle \"" + "org/apache/xml/security/resource/xmlsecurity" + "\"";
            }
            return NOT_INITIALIZED_MSG;
        }
    }

    public static void init(String string, String string2) {
        defaultLanguageCode = string;
        if (defaultLanguageCode == null) {
            defaultLanguageCode = Locale.getDefault().getLanguage();
        }
        if ((defaultCountryCode = string2) == null) {
            defaultCountryCode = Locale.getDefault().getCountry();
        }
        I18n.initLocale(defaultLanguageCode, defaultCountryCode);
    }

    public static void initLocale(String string, String string2) {
        if (alreadyInitialized && string.equals(_languageCode) && string2.equals(_countryCode)) {
            return;
        }
        if (string != null && string2 != null && string.length() > 0 && string2.length() > 0) {
            _languageCode = string;
            _countryCode = string2;
        } else {
            _countryCode = defaultCountryCode;
            _languageCode = defaultLanguageCode;
        }
        resourceBundle = ResourceBundle.getBundle("org/apache/xml/security/resource/xmlsecurity", new Locale(_languageCode, _countryCode));
    }

    static {
        alreadyInitialized = false;
        _languageCode = null;
        _countryCode = null;
    }
}

