/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SimpleConditionalExpressionNode;
import org.eclipse.persistence.internal.jpa.parsing.SubqueryNode;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.queries.ReportQuery;

public class InNode
extends SimpleConditionalExpressionNode {
    private List theObjects = null;
    private boolean notIndicated = false;
    private boolean isListParameterOrSubquery = false;

    public void addNodeToTheObjects(Node theNode) {
        this.getTheObjects().add(theNode);
    }

    public void validate(ParseTreeContext context) {
        Class<Collection> leftType = null;
        TypeHelper typeHelper = context.getTypeHelper();
        if (this.left != null) {
            this.left.validate(context);
            leftType = this.isListParameterOrSubquery && !this.getTheObjects().isEmpty() && ((Node)this.getTheObjects().get(0)).isParameterNode() ? Collection.class : this.left.getType();
        }
        for (Node node : this.getTheObjects()) {
            node.validate(context);
            node.validateParameter(context, leftType);
            Object nodeType = node.getType();
            if (leftType == null || typeHelper.isAssignableFrom(leftType, nodeType)) continue;
            throw JPQLException.invalidExpressionArgument(context.getQueryInfo(), node.getLine(), node.getColumn(), "IN", node.getAsString(), typeHelper.getTypeName(leftType));
        }
        this.setType(typeHelper.getBooleanType());
    }

    public Expression generateExpression(GenerationContext context) {
        Expression whereClause = this.getLeft().generateExpression(context);
        List arguments = this.getTheObjects();
        Node firstArg = (Node)arguments.get(0);
        if (firstArg.isSubqueryNode()) {
            SubqueryNode subqueryNode = (SubqueryNode)firstArg;
            ReportQuery reportQuery = subqueryNode.getReportQuery(context);
            whereClause = this.notIndicated() ? whereClause.notIn(reportQuery) : whereClause.in(reportQuery);
        } else if (this.isListParameterOrSubquery && firstArg.isParameterNode()) {
            whereClause = this.notIndicated() ? whereClause.notIn(firstArg.generateExpression(context)) : whereClause.in(firstArg.generateExpression(context));
        } else {
            Vector<Expression> inArguments = new Vector<Expression>(arguments.size());
            for (Node nextNode : arguments) {
                inArguments.add(nextNode.generateExpression(context));
            }
            if (inArguments.size() > 0) {
                whereClause = this.notIndicated() ? whereClause.notIn(inArguments) : whereClause.in(inArguments);
            }
        }
        return whereClause;
    }

    public List getTheObjects() {
        if (this.theObjects == null) {
            this.setTheObjects(new Vector());
        }
        return this.theObjects;
    }

    public void setIsListParameterOrSubquery(boolean isListParameterOrSubquery) {
        this.isListParameterOrSubquery = isListParameterOrSubquery;
    }

    public void setTheObjects(List newTheObjects) {
        this.theObjects = newTheObjects;
    }

    public void indicateNot() {
        this.notIndicated = true;
    }

    public boolean notIndicated() {
        return this.notIndicated;
    }
}

