/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.asm.ClassReader;
import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.asm.commons.EmptyVisitor;
import org.springframework.core.CollectionFactory;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.ClassUtils;

public class LocalVariableTableParameterNameDiscoverer
implements ParameterNameDiscoverer {
    private static Log logger = LogFactory.getLog((Class)LocalVariableTableParameterNameDiscoverer.class);
    private final Map parameterNamesCache = CollectionFactory.createConcurrentMapIfPossible(16);
    private final Map classReaderCache = new HashMap();

    public String[] getParameterNames(Method method) {
        String[] paramNames;
        block4: {
            paramNames = (String[])this.parameterNamesCache.get(method);
            if (paramNames == null) {
                try {
                    paramNames = this.visitMethod(method).getParameterNames();
                    if (paramNames != null) {
                        this.parameterNamesCache.put(method, paramNames);
                    }
                }
                catch (IOException ex) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)("IOException whilst attempting to read '.class' file for class [" + method.getDeclaringClass().getName() + "] - unable to determine parameter names for method: " + method), (Throwable)ex);
                }
            }
        }
        return paramNames;
    }

    public String[] getParameterNames(Constructor ctor) {
        String[] paramNames;
        block4: {
            paramNames = (String[])this.parameterNamesCache.get(ctor);
            if (paramNames == null) {
                try {
                    paramNames = this.visitConstructor(ctor).getParameterNames();
                    if (paramNames != null) {
                        this.parameterNamesCache.put(ctor, paramNames);
                    }
                }
                catch (IOException ex) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)("IOException whilst attempting to read '.class' file for class [" + ctor.getDeclaringClass().getName() + "] - unable to determine parameter names for constructor: " + ctor), (Throwable)ex);
                }
            }
        }
        return paramNames;
    }

    private ParameterNameDiscoveringVisitor visitMethod(Method method) throws IOException {
        ClassReader classReader = this.getClassReader(method.getDeclaringClass());
        FindMethodParameterNamesClassVisitor classVisitor = new FindMethodParameterNamesClassVisitor(method);
        classReader.accept(classVisitor, false);
        return classVisitor;
    }

    private ParameterNameDiscoveringVisitor visitConstructor(Constructor ctor) throws IOException {
        ClassReader classReader = this.getClassReader(ctor.getDeclaringClass());
        FindConstructorParameterNamesClassVisitor classVisitor = new FindConstructorParameterNamesClassVisitor(ctor);
        classReader.accept(classVisitor, false);
        return classVisitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassReader getClassReader(Class clazz) throws IOException {
        Map map = this.classReaderCache;
        synchronized (map) {
            ClassReader classReader = (ClassReader)this.classReaderCache.get(clazz);
            if (classReader == null) {
                InputStream is = clazz.getResourceAsStream(ClassUtils.getClassFileName(clazz));
                if (is == null) {
                    throw new FileNotFoundException("Class file for class [" + clazz.getName() + "] not found");
                }
                try {
                    classReader = new ClassReader(is);
                    this.classReaderCache.put(clazz, classReader);
                }
                finally {
                    is.close();
                }
            }
            return classReader;
        }
    }

    private static class LocalVariableTableVisitor
    extends EmptyVisitor {
        private final ParameterNameDiscoveringVisitor memberVisitor;
        private final boolean isStatic;
        private String[] parameterNames;
        private boolean hasLvtInfo = false;

        public LocalVariableTableVisitor(ParameterNameDiscoveringVisitor memberVisitor, boolean isStatic) {
            this.memberVisitor = memberVisitor;
            this.isStatic = isStatic;
            this.parameterNames = new String[memberVisitor.numParamsExpected];
        }

        public void visitLocalVariable(String name, String description, String signature, Label start, Label end, int index) {
            this.hasLvtInfo = true;
            int[] lvtSlotIndices = this.memberVisitor.lvtSlotIndex;
            for (int i = 0; i < lvtSlotIndices.length; ++i) {
                if (lvtSlotIndices[i] != index) continue;
                this.parameterNames[i] = name;
            }
        }

        public void visitEnd() {
            if (this.hasLvtInfo || this.isStatic && this.parameterNames.length == 0) {
                ParameterNameDiscoveringVisitor.access$202(this.memberVisitor, this.parameterNames);
            }
        }
    }

    private static class FindConstructorParameterNamesClassVisitor
    extends ParameterNameDiscoveringVisitor {
        public FindConstructorParameterNamesClassVisitor(Constructor ctor) {
            super("<init>", false, ctor.getParameterTypes());
            Type[] pTypes = new Type[ctor.getParameterTypes().length];
            for (int i = 0; i < pTypes.length; ++i) {
                pTypes[i] = Type.getType(ctor.getParameterTypes()[i]);
            }
            this.setDescriptorToMatch(Type.getMethodDescriptor(Type.VOID_TYPE, pTypes));
        }
    }

    private static class FindMethodParameterNamesClassVisitor
    extends ParameterNameDiscoveringVisitor {
        public FindMethodParameterNamesClassVisitor(Method method) {
            super(method.getName(), Modifier.isStatic(method.getModifiers()), method.getParameterTypes());
            this.setDescriptorToMatch(Type.getMethodDescriptor(method));
        }
    }

    private static abstract class ParameterNameDiscoveringVisitor
    extends EmptyVisitor {
        private String methodNameToMatch;
        private String descriptorToMatch;
        private int numParamsExpected;
        private int[] lvtSlotIndex;
        private String[] parameterNames;

        public ParameterNameDiscoveringVisitor(String name, boolean isStatic, Class[] paramTypes) {
            this.methodNameToMatch = name;
            this.numParamsExpected = paramTypes.length;
            this.computeLvtSlotIndices(isStatic, paramTypes);
        }

        public void setDescriptorToMatch(String descriptor) {
            this.descriptorToMatch = descriptor;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (name.equals(this.methodNameToMatch) && desc.equals(this.descriptorToMatch)) {
                return new LocalVariableTableVisitor(this, this.isStatic(access));
            }
            return null;
        }

        private boolean isStatic(int access) {
            return (access & 8) > 0;
        }

        public String[] getParameterNames() {
            return this.parameterNames;
        }

        private void computeLvtSlotIndices(boolean isStatic, Class[] paramTypes) {
            this.lvtSlotIndex = new int[paramTypes.length];
            int nextIndex = isStatic ? 0 : 1;
            for (int i = 0; i < paramTypes.length; ++i) {
                this.lvtSlotIndex[i] = nextIndex++;
                if (!this.isWideType(paramTypes[i])) continue;
                nextIndex += 2;
            }
        }

        private boolean isWideType(Class aType) {
            return aType == Long.TYPE || aType == Double.TYPE;
        }

        static /* synthetic */ String[] access$202(ParameterNameDiscoveringVisitor x0, String[] x1) {
            x0.parameterNames = x1;
            return x1;
        }
    }
}

