/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.annotation;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import org.springframework.transaction.annotation.TransactionAnnotationParser;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class SpringTransactionAnnotationParser
implements TransactionAnnotationParser,
Serializable {
    public TransactionAttribute parseTransactionAnnotation(AnnotatedElement ae) {
        Transactional ann = ae.getAnnotation(Transactional.class);
        if (ann != null) {
            return this.parseTransactionAnnotation(ann);
        }
        return null;
    }

    public TransactionAttribute parseTransactionAnnotation(Transactional ann) {
        RuleBasedTransactionAttribute rbta = new RuleBasedTransactionAttribute();
        rbta.setPropagationBehavior(ann.propagation().value());
        rbta.setIsolationLevel(ann.isolation().value());
        rbta.setTimeout(ann.timeout());
        rbta.setReadOnly(ann.readOnly());
        ArrayList<RollbackRuleAttribute> rollBackRules = new ArrayList<RollbackRuleAttribute>();
        Class<? extends Throwable>[] rbf = ann.rollbackFor();
        for (int i = 0; i < rbf.length; ++i) {
            RollbackRuleAttribute rule = new RollbackRuleAttribute(rbf[i]);
            rollBackRules.add(rule);
        }
        String[] rbfc = ann.rollbackForClassName();
        for (int i = 0; i < rbfc.length; ++i) {
            RollbackRuleAttribute rule = new RollbackRuleAttribute(rbfc[i]);
            rollBackRules.add(rule);
        }
        Class<? extends Throwable>[] nrbf = ann.noRollbackFor();
        for (int i = 0; i < nrbf.length; ++i) {
            NoRollbackRuleAttribute rule = new NoRollbackRuleAttribute(nrbf[i]);
            rollBackRules.add(rule);
        }
        String[] nrbfc = ann.noRollbackForClassName();
        for (int i = 0; i < nrbfc.length; ++i) {
            NoRollbackRuleAttribute rule = new NoRollbackRuleAttribute(nrbfc[i]);
            rollBackRules.add(rule);
        }
        rbta.getRollbackRules().addAll(rollBackRules);
        return rbta;
    }
}

