/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.RoutingSlip;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="routingSlip")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RoutingSlipDefinition
extends ProcessorDefinition<ProcessorDefinition> {
    public static final String DEFAULT_DELIMITER = ",";
    @XmlAttribute
    private String headerName;
    @XmlAttribute
    private String uriDelimiter;
    @XmlAttribute
    private Boolean ignoreInvalidEndpoints;

    public RoutingSlipDefinition() {
        this(null, DEFAULT_DELIMITER);
    }

    public RoutingSlipDefinition(String headerName) {
        this(headerName, DEFAULT_DELIMITER);
    }

    public RoutingSlipDefinition(String headerName, String uriDelimiter) {
        this.setHeaderName(headerName);
        this.setUriDelimiter(uriDelimiter);
    }

    public String toString() {
        return "RoutingSlip[headerName=" + this.getHeaderName() + ", uriDelimiter=" + this.getUriDelimiter() + "]";
    }

    @Override
    public String getShortName() {
        return "routingSlip";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ObjectHelper.notEmpty(this.getHeaderName(), "headerName", this);
        ObjectHelper.notEmpty(this.getUriDelimiter(), "uriDelimiter", this);
        RoutingSlip routingSlip = new RoutingSlip(routeContext.getCamelContext(), this.getHeaderName(), this.getUriDelimiter());
        if (this.getIgnoreInvalidEndpoint() != null) {
            routingSlip.setIgnoreInvalidEndpoints(this.getIgnoreInvalidEndpoint());
        }
        return routingSlip;
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return Collections.emptyList();
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setUriDelimiter(String uriDelimiter) {
        this.uriDelimiter = uriDelimiter;
    }

    public String getUriDelimiter() {
        return this.uriDelimiter;
    }

    public void setIgnoreInvalidEndpoints(Boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    public Boolean getIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoints;
    }
}

