/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.metainfo.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.jorm.lib.JormPathHelper;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassRef;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.ScalarField;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.jorm.metainfo.lib.BasicClassRef;
import org.objectweb.jorm.metainfo.lib.BasicMetaObject;
import org.objectweb.jorm.metainfo.lib.BasicNameDef;
import org.objectweb.jorm.metainfo.lib.BasicPrimitiveElement;
import org.objectweb.jorm.metainfo.lib.BasicScalarField;
import org.objectweb.jorm.type.api.PExceptionTyping;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.util.monolog.api.BasicLevel;

public class BasicGenClassRef
extends BasicMetaObject
implements GenClassRef,
Comparable {
    private static final String PRIMITIVE_ELEMENT_NAME = "element";
    private String name;
    private String genClassName;
    private String genClassId;
    private ScalarField indexField;
    private ArrayList refNameDefs;
    private ArrayList idNameDefs;
    private Map hiddenFields;
    private List indexFields;
    private boolean primitive;
    private boolean classRef;
    private boolean genClassRef;
    private GenClassRef currentGenClassRef;
    private ClassRef currentClassRef;
    private PrimitiveElement primitiveElement;
    private PType type;

    public BasicGenClassRef(String genClassName, String name, MetaObject parent) {
        super(parent);
        this.name = name;
        this.genClassName = genClassName;
        this.indexField = null;
        this.hiddenFields = new HashMap();
        this.refNameDefs = new ArrayList();
        this.idNameDefs = new ArrayList();
        this.indexFields = new ArrayList();
        this.genClassId = JormPathHelper.getPath(this, false);
    }

    public int compareTo(Object o) {
        return this.name.compareTo(((TypedElement)o).getName());
    }

    public PrimitiveElement createPrimitiveElement(PType type, int size, int scale) {
        this.primitiveElement = new BasicPrimitiveElement("element_" + type.getJormName(), type, size, scale, this);
        this.setLoggingOnChild(this.primitiveElement);
        this.primitive = true;
        this.classRef = false;
        this.genClassRef = false;
        return this.primitiveElement;
    }

    public ScalarField createIndexField(String indexFieldName, PType type, int size, int scale) {
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("create a new PrimitiveElement (index field (" + indexFieldName + ")) for the current " + "GenClass (" + this.genClassName + ")"));
        }
        BasicScalarField sf = new BasicScalarField(indexFieldName, type, size, scale, this);
        this.setLoggingOnChild(sf);
        return sf;
    }

    public ScalarField getIndexField() {
        return this.indexField;
    }

    public ClassRef createClassRef(Class clazz) {
        String classname = clazz.getName();
        int idx = classname.lastIndexOf(46);
        if (idx != -1) {
            classname = classname.substring(idx + 1, classname.length());
        }
        this.currentClassRef = new BasicClassRef(classname, clazz, this);
        this.setLoggingOnChild(this.currentClassRef);
        this.classRef = true;
        this.genClassRef = false;
        this.primitive = false;
        return this.currentClassRef;
    }

    public GenClassRef createGenClassRef(String genClassRefName) {
        this.classRef = false;
        this.genClassRef = true;
        this.primitive = false;
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("create a new GenClassRef (" + genClassRefName + ") for the current GenClassRef (" + this.name + ")"));
        }
        if (this.currentGenClassRef == null) {
            this.currentGenClassRef = new BasicGenClassRef(genClassRefName, null, this);
            this.setLoggingOnChild(this.currentGenClassRef);
        }
        return this.currentGenClassRef;
    }

    public PrimitiveElement getPrimitiveElement() {
        return this.primitiveElement;
    }

    public TypedElement removeTypedElement(String fieldName) {
        TypedElement res = (TypedElement)this.hiddenFields.remove(fieldName);
        return res;
    }

    public ClassRef getClassRef() {
        return this.currentClassRef;
    }

    public GenClassRef getGenClassRef() {
        return this.currentGenClassRef;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isClassRef() {
        return this.classRef;
    }

    public boolean isGenClassRef() {
        return this.genClassRef;
    }

    public NameDef createIdNameDef() {
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("create a new ID NameDef () for the current GenClassRef (" + this.name + ")"));
        }
        BasicNameDef newNameDef = new BasicNameDef(this);
        this.setLoggingOnChild(newNameDef);
        this.idNameDefs.add(newNameDef);
        return newNameDef;
    }

    public Collection getIdNameDef() {
        return this.idNameDefs;
    }

    public ScalarField createHiddenField(String fieldName, PType type, int size, int scale) {
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("create a new HiddenField (" + fieldName + ") for the current refgenclass (" + this.name + ")"));
        }
        if (this.hiddenFields.get(fieldName) != null) {
            if (this.logger != null) {
                this.logger.log(BasicLevel.WARN, (Object)("attention, try to create an existing HiddenField (" + fieldName + "), return existing one"));
            }
            return (ScalarField)this.hiddenFields.get(fieldName);
        }
        BasicScalarField newHiddenField = new BasicScalarField(fieldName, type, size, scale, this);
        this.setLoggingOnChild(newHiddenField);
        this.hiddenFields.put(fieldName, newHiddenField);
        return newHiddenField;
    }

    public Collection getHiddenFields() {
        return this.hiddenFields.values();
    }

    public ScalarField getHiddenField(String fieldName) {
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("try to return an hidden field (" + fieldName + ")"));
        }
        return (ScalarField)this.hiddenFields.get(fieldName);
    }

    public String getGenClassName() {
        return this.genClassName;
    }

    public String getGenClassId() {
        return this.genClassId;
    }

    public NameDef createRefNameDef() {
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("create a new REF NameDef () for the current Class (" + this.name + ")"));
        }
        BasicNameDef newNameDef = new BasicNameDef(this);
        this.setLoggingOnChild(newNameDef);
        this.refNameDefs.add(newNameDef);
        return newNameDef;
    }

    public NameDef getRefNameDef(String name) {
        Iterator iter = this.refNameDefs.iterator();
        while (iter.hasNext()) {
            NameDef nameDef = (NameDef)iter.next();
            if (!nameDef.getName().equals(name)) continue;
            return nameDef;
        }
        return null;
    }

    public NameDef getIdNameDef(String name) {
        Iterator iter = this.idNameDefs.iterator();
        while (iter.hasNext()) {
            NameDef nameDef = (NameDef)iter.next();
            if (!nameDef.getName().equals(name)) continue;
            return nameDef;
        }
        return null;
    }

    public Collection getRefNameDef() {
        return this.refNameDefs;
    }

    public void addIndexField(String indexFieldName) {
        this.indexFields.add(this.hiddenFields.get(indexFieldName));
    }

    public Collection getIndexFields() {
        return this.indexFields;
    }

    protected Collection getChildren() {
        ArrayList res = new ArrayList();
        res.addAll(this.hiddenFields.values());
        res.addAll(this.refNameDefs);
        res.addAll(this.idNameDefs);
        return res;
    }

    public String getName() {
        return this.name;
    }

    public PType getType() {
        block8: {
            if (this.type != null) {
                return this.type;
            }
            try {
                if (this.primitive) {
                    this.type = this.getManager().getPTypeSpace().createPType(new String[]{this.genClassName}, this.primitiveElement.getType());
                } else if (this.classRef) {
                    this.type = this.getManager().getPTypeSpace().createPType(new String[]{this.genClassName}, this.currentClassRef.getType());
                } else {
                    ArrayList<String> al = new ArrayList<String>();
                    GenClassRef gcr = this;
                    al.add(gcr.getGenClassName());
                    while (gcr.isGenClassRef()) {
                        al.add(gcr.getGenClassName());
                        gcr = gcr.getGenClassRef();
                    }
                    PType lasttype = null;
                    lasttype = gcr.isClassRef() ? gcr.getClassRef().getType() : gcr.getPrimitiveElement().getType();
                    this.type = this.getManager().getPTypeSpace().createPType(al.toArray(new String[0]), lasttype);
                }
            }
            catch (PExceptionTyping e) {
                if (this.logger == null) break block8;
                this.logger.log(BasicLevel.ERROR, (Object)("Impossible to calculate the type of the GenClassRef field " + this.genClassId), (Throwable)e);
            }
        }
        return this.type;
    }
}

