/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.audit.internal.webauditor.filters;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.modelmbean.ModelMBeanNotificationBroadcaster;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ow2.jonas.audit.internal.webauditor.report.WebInvocationAuditReportFactory;
import org.ow2.util.auditreport.impl.CurrentInvocationID;
import org.ow2.util.auditreport.impl.WebInvocationAuditReport;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class HttpAuditFilter
implements Filter {
    private static Log logger = LogFactory.getLog(HttpAuditFilter.class);
    private FilterConfig filterConfig = null;
    private long seqNumber = 0L;
    private List<String> filters = new ArrayList<String>();
    private WebInvocationAuditReportFactory webInvocationAuditReportFactory = null;
    private ModelMBeanNotificationBroadcaster broadcaster = null;

    public HttpAuditFilter(MBeanServer jmxServer) {
        this.webInvocationAuditReportFactory = new WebInvocationAuditReportFactory(jmxServer);
        this.filters.add("graniteamf");
        this.filters.add(".png");
        this.filters.add(".jpeg");
        this.filters.add(".jpg");
        this.filters.add(".gif");
        this.filters.add(".css");
        this.filters.add(".bmp");
        this.filters.add(".ico");
    }

    private boolean uriFilter(String uri) {
        boolean ret = false;
        for (String elem : this.filters) {
            if (!uri.contains(elem)) continue;
            ret = true;
        }
        return ret;
    }

    private WebInvocationAuditReport doBeforeProcessing(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletRequest hreq = (HttpServletRequest)request;
        CurrentInvocationID.getInstance().init(null);
        ++this.seqNumber;
        return this.webInvocationAuditReportFactory.prepareAuditReport(this.seqNumber, System.currentTimeMillis(), System.nanoTime(), Thread.currentThread(), "web", hreq);
    }

    private void doAfterProcessing(ServletRequest request, HttpServletResponse response, WebInvocationAuditReport report) throws IOException, ServletException {
        CurrentInvocationID.getInstance().setAuditID(null);
        try {
            Integer i;
            int status = -1;
            Method m = response.getClass().getMethod("getStatus", new Class[0]);
            if (m != null && (i = (Integer)m.invoke((Object)response, new Object[0])) != null) {
                status = i;
            }
            if (report != null) {
                this.webInvocationAuditReportFactory.completeAuditReport(report, System.nanoTime(), response.getContentType());
                report.setStatus(status);
                this.broadcaster.sendNotification(new Notification(WebInvocationAuditReport.class.getName(), (Object)this.broadcaster, this.seqNumber, report.toString()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to make a report", new Object[]{e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.uriFilter(((HttpServletRequest)request).getRequestURI())) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        WebInvocationAuditReport report = this.doBeforeProcessing(request, (ServletResponse)httpServletResponse);
        try {
            chain.doFilter(request, (ServletResponse)httpServletResponse);
        }
        finally {
            this.doAfterProcessing(request, httpServletResponse, report);
        }
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public String toString() {
        if (this.filterConfig == null) {
            return "SimpleFilter()";
        }
        StringBuffer sb = new StringBuffer("SimpleFilter(");
        sb.append(this.filterConfig);
        sb.append(")");
        return sb.toString();
    }

    public static String getStackTrace(Throwable t) {
        String stackTrace = null;
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            sw.close();
            stackTrace = sw.getBuffer().toString();
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        return stackTrace;
    }

    public void log(String msg) {
        this.filterConfig.getServletContext().log(msg);
    }

    public void setBroadcaster(ModelMBeanNotificationBroadcaster broadcaster) {
        this.broadcaster = broadcaster;
    }
}

