/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.signing;

import aQute.bnd.service.Plugin;
import aQute.bnd.service.SignerPlugin;
import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Resource;
import aQute.libg.reporter.Reporter;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JartoolSigner
implements Plugin,
SignerPlugin {
    String keystore;
    String storetype;
    String path = "jarsigner";
    String storepass;
    String keypass;
    String sigFile;

    @Override
    public void setProperties(Map<String, String> map) {
        if (map.containsKey("keystore")) {
            this.keystore = map.get("keystore");
        }
        if (map.containsKey("storetype")) {
            this.storetype = map.get("storetype");
        }
        if (map.containsKey("storepass")) {
            this.storepass = map.get("storepass");
        }
        if (map.containsKey("keypass")) {
            this.keypass = map.get("keypass");
        }
        if (map.containsKey("path")) {
            this.path = map.get("path");
        }
        if (map.containsKey("sigFile")) {
            this.sigFile = map.get("sigFile");
        }
    }

    @Override
    public void setReporter(Reporter processor) {
    }

    @Override
    public void sign(Builder builder, String alias) throws Exception {
        Jar jar = builder.getJar();
        File tmp = File.createTempFile("signdjar", ".jar");
        tmp.deleteOnExit();
        jar.write(tmp);
        StringBuilder sb = new StringBuilder();
        sb.append(this.path);
        if (this.keystore != null) {
            sb.append(" -keystore ");
            sb.append(this.keystore);
        }
        if (this.storetype != null) {
            sb.append(" -storetype ");
            sb.append(this.storetype);
        }
        if (this.keypass != null) {
            sb.append(" -keypass ");
            sb.append(this.keypass);
        }
        if (this.storepass != null) {
            sb.append(" -storepass ");
            sb.append(this.storepass);
        }
        if (this.sigFile != null) {
            sb.append(" -sigFile ");
            sb.append(this.sigFile);
        }
        sb.append(" ");
        sb.append(tmp.getAbsolutePath());
        sb.append(" ");
        sb.append(alias);
        String cmd = sb.toString();
        builder.trace(cmd, new Object[0]);
        final Process process = Runtime.getRuntime().exec(cmd);
        Thread t = new Thread(){

            public void run() {
                try {
                    JartoolSigner.this.collect(process.getInputStream());
                    JartoolSigner.this.collect(process.getErrorStream());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        process.waitFor();
        if (process.exitValue() != 0) {
            builder.error("Signing Jar: ", new Object[0]);
        }
        Jar signed = new Jar(tmp);
        builder.addClose(signed);
        Map<String, Resource> dir = signed.getDirectories().get("META-INF");
        for (String path : dir.keySet()) {
            if (!path.matches(".*\\.(DSA|RSA|SF|MF)$")) continue;
            jar.putResource(path, dir.get(path));
        }
        jar.setDoNotTouchManifest();
    }

    String collect(InputStream in) throws Exception {
        StringBuilder sb = new StringBuilder();
        BufferedReader rdr = new BufferedReader(new InputStreamReader(in));
        String line = rdr.readLine();
        while (line != null) {
            System.out.println(line);
            sb.append(line);
            line = rdr.readLine();
        }
        rdr.close();
        in.close();
        return sb.toString();
    }
}

