/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.smartclient.spi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;

public class ProDelegate
implements PortableRemoteObjectDelegate {
    private static Logger logger = Logger.getLogger(ProDelegate.class.getName());
    private static final String CAROL_PRO_DELEGATE = "org.objectweb.carol.rmi.multi.MultiPRODelegate";
    private static ClassLoader classLoader;
    private PortableRemoteObjectDelegate wrapped = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProDelegate() {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass(CAROL_PRO_DELEGATE);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot find the 'org.objectweb.carol.rmi.multi.MultiPRODelegate' class.", e);
            }
            try {
                this.wrapped = (PortableRemoteObjectDelegate)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Cannot build an instance of the 'org.objectweb.carol.rmi.multi.MultiPRODelegate' class.", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Cannot build an instance of the 'org.objectweb.carol.rmi.multi.MultiPRODelegate' class.", e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void check() {
        if (classLoader == null) {
            throw new IllegalStateException("No classloader was set previously. Invalid call.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Remote target, Remote source) throws RemoteException {
        this.check();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "connect '" + target + "' with '" + source + "'.");
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            this.wrapped.connect(target, source);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportObject(Remote obj) throws RemoteException {
        this.check();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "exportObject '" + obj + "'.");
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            this.wrapped.exportObject(obj);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object narrow(Object narrowFrom, Class narrowTo) throws ClassCastException {
        this.check();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Narrowing '" + narrowFrom + "' to '" + narrowTo + "'.");
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            Object object = this.wrapped.narrow(narrowFrom, narrowTo);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Remote toStub(Remote obj) throws NoSuchObjectException {
        this.check();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "toStub '" + obj + "'.");
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            Remote remote = this.wrapped.toStub(obj);
            return remote;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unexportObject(Remote obj) throws NoSuchObjectException {
        this.check();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "unexportObject '" + obj + "'.");
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            this.wrapped.unexportObject(obj);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public static void setClassLoader(ClassLoader cl) {
        classLoader = cl;
    }
}

