/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.mdb.helper;

import javax.resource.ResourceException;
import javax.resource.spi.ResourceAdapter;
import org.ow2.easybeans.component.api.EZBComponent;
import org.ow2.easybeans.component.itf.JMSComponent;
import org.ow2.easybeans.container.mdb.helper.IResourceAdapterFinder;
import org.ow2.easybeans.server.Embedded;

public final class MDBResourceAdapterHelper {
    private static IResourceAdapterFinder resourceAdapterFinder = null;

    private MDBResourceAdapterHelper() {
    }

    public static ResourceAdapter getResourceAdapter(String jndiName, Embedded embedded) throws ResourceException {
        if (resourceAdapterFinder != null) {
            return resourceAdapterFinder.getResourceAdapter(jndiName);
        }
        EZBComponent component = embedded.getComponent("org.ow2.easybeans.component.joram.JoramComponent");
        if (component != null) {
            if (component instanceof JMSComponent) {
                return ((JMSComponent)component).getResourceAdapter();
            }
            throw new IllegalArgumentException("The 'jms' component doesn't implement JMSComponent interface.");
        }
        throw new ResourceException("MDB is used but no resource service was started.");
    }

    public static void setResourceAdapterFinder(IResourceAdapterFinder finder) {
        if (resourceAdapterFinder != null) {
            throw new IllegalStateException("Unable to set the finder. It is already set");
        }
        resourceAdapterFinder = finder;
    }
}

