/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.reader;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.reader.ReaderProviderHelper;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

@Deprecated
public class SharedReaderProvider
implements ReaderProvider {
    private static final Logger log = LoggerFactory.make();
    private final Lock semaphoreIndexReaderLock = new ReentrantLock();
    private Map<DirectoryProvider, Lock> perDirectoryProviderManipulationLocks;
    private Map<DirectoryProvider, IndexReader> activeSearchIndexReaders = new HashMap<DirectoryProvider, IndexReader>();
    private Map<IndexReader, ReaderData> searchIndexReaderSemaphores = new HashMap<IndexReader, ReaderData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexReader openReader(DirectoryProvider ... directoryProviders) {
        boolean trace = log.isTraceEnabled();
        int length = directoryProviders.length;
        IndexReader[] readers = new IndexReader[length];
        if (trace) {
            log.trace("Opening IndexReader for directoryProviders: {}", (Object)length);
        }
        for (int index = 0; index < length; ++index) {
            IndexReader reader;
            DirectoryProvider directoryProvider = directoryProviders[index];
            Lock directoryProviderLock = this.perDirectoryProviderManipulationLocks.get(directoryProvider);
            if (trace) {
                log.trace("Opening IndexReader from {}", directoryProvider.getDirectory());
            }
            directoryProviderLock.lock();
            try {
                reader = this.activeSearchIndexReaders.get(directoryProvider);
            }
            finally {
                directoryProviderLock.unlock();
            }
            if (reader == null) {
                if (trace) {
                    log.trace("No shared IndexReader, opening a new one: {}", directoryProvider.getDirectory());
                }
                reader = this.replaceActiveReader(null, directoryProviderLock, directoryProvider, readers);
            } else {
                boolean isCurrent;
                try {
                    isCurrent = reader.isCurrent();
                }
                catch (IOException e) {
                    throw new SearchException("Unable to read current status of Lucene IndexReader", e);
                }
                if (!isCurrent) {
                    if (trace) {
                        log.trace("Out of date shared IndexReader found, opening a new one: {}", directoryProvider.getDirectory());
                    }
                    IndexReader outOfDateReader = reader;
                    reader = this.replaceActiveReader(outOfDateReader, directoryProviderLock, directoryProvider, readers);
                } else {
                    if (trace) {
                        log.trace("Valid shared IndexReader: {}" + directoryProvider.getDirectory());
                    }
                    directoryProviderLock.lock();
                    try {
                        reader = this.activeSearchIndexReaders.get(directoryProvider);
                        this.semaphoreIndexReaderLock.lock();
                        try {
                            ReaderData readerData = this.searchIndexReaderSemaphores.get(reader);
                            ++readerData.semaphore;
                            this.searchIndexReaderSemaphores.put(reader, readerData);
                            if (trace) {
                                log.trace("Semaphore increased: {} for {}", (Object)readerData.semaphore, (Object)reader);
                            }
                        }
                        finally {
                            this.semaphoreIndexReaderLock.unlock();
                        }
                    }
                    finally {
                        directoryProviderLock.unlock();
                    }
                }
            }
            readers[index] = reader;
        }
        return ReaderProviderHelper.buildMultiReader(length, readers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexReader replaceActiveReader(IndexReader outOfDateReader, Lock directoryProviderLock, DirectoryProvider directoryProvider, IndexReader[] readers) {
        IndexReader oldReader;
        IndexReader reader;
        boolean trace = log.isTraceEnabled();
        boolean closeOldReader = false;
        boolean closeOutOfDateReader = false;
        try {
            reader = IndexReader.open(directoryProvider.getDirectory(), (boolean)true);
        }
        catch (IOException e) {
            throw new SearchException("Unable to open Lucene IndexReader", e);
        }
        directoryProviderLock.lock();
        try {
            oldReader = this.activeSearchIndexReaders.put(directoryProvider, reader);
            this.semaphoreIndexReaderLock.lock();
            try {
                ReaderData readerData;
                this.searchIndexReaderSemaphores.put(reader, new ReaderData(1, directoryProvider));
                if (trace) {
                    log.trace("Semaphore: 1 for {}", (Object)reader);
                }
                if (outOfDateReader != null) {
                    readerData = this.searchIndexReaderSemaphores.get(outOfDateReader);
                    if (readerData == null) {
                        closeOutOfDateReader = false;
                    } else if (readerData.semaphore == 0) {
                        this.searchIndexReaderSemaphores.remove(outOfDateReader);
                        closeOutOfDateReader = true;
                    } else {
                        closeOutOfDateReader = false;
                    }
                }
                if (oldReader != null && oldReader != outOfDateReader) {
                    readerData = this.searchIndexReaderSemaphores.get(oldReader);
                    if (readerData == null) {
                        log.warn("Semaphore should not be null");
                        closeOldReader = true;
                    } else if (readerData.semaphore == 0) {
                        this.searchIndexReaderSemaphores.remove(oldReader);
                        closeOldReader = true;
                    } else {
                        closeOldReader = false;
                    }
                }
            }
            finally {
                this.semaphoreIndexReaderLock.unlock();
            }
        }
        finally {
            directoryProviderLock.unlock();
        }
        if (closeOutOfDateReader) {
            if (trace) {
                log.trace("Closing out of date IndexReader {}", (Object)outOfDateReader);
            }
            try {
                outOfDateReader.close();
            }
            catch (IOException e) {
                ReaderProviderHelper.clean(new SearchException("Unable to close Lucene IndexReader", e), readers);
            }
        }
        if (closeOldReader) {
            if (trace) {
                log.trace("Closing old IndexReader {}", (Object)oldReader);
            }
            try {
                oldReader.close();
            }
            catch (IOException e) {
                ReaderProviderHelper.clean(new SearchException("Unable to close Lucene IndexReader", e), readers);
            }
        }
        return reader;
    }

    public void closeReader(IndexReader reader) {
        IndexReader[] readers;
        boolean trace = log.isTraceEnabled();
        if (reader == null) {
            return;
        }
        if (reader instanceof MultiReader) {
            readers = ReaderProviderHelper.getSubReadersFromMultiReader((MultiReader)reader);
            if (trace) {
                log.trace("Closing MultiReader: {}", (Object)reader);
            }
        } else {
            throw new AssertionFailure("Everything should be wrapped in a MultiReader");
        }
        for (IndexReader subReader : readers) {
            this.closeInternalReader(trace, subReader, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternalReader(boolean trace, IndexReader subReader, boolean finalClose) {
        ReaderData readerData;
        this.semaphoreIndexReaderLock.lock();
        try {
            readerData = this.searchIndexReaderSemaphores.get(subReader);
        }
        finally {
            this.semaphoreIndexReaderLock.unlock();
        }
        if (readerData == null) {
            log.error("Trying to close a Lucene IndexReader not present: {}", (Object)subReader.directory());
            return;
        }
        Lock directoryProviderLock = this.perDirectoryProviderManipulationLocks.get(readerData.provider);
        boolean closeReader = false;
        directoryProviderLock.lock();
        try {
            boolean isActive;
            boolean bl = isActive = this.activeSearchIndexReaders.get(readerData.provider) == subReader;
            if (trace) {
                log.trace("Indexreader not active: {}", (Object)subReader);
            }
            this.semaphoreIndexReaderLock.lock();
            try {
                readerData = this.searchIndexReaderSemaphores.get(subReader);
                if (readerData == null) {
                    log.error("Trying to close a Lucene IndexReader not present: {}" + subReader.directory());
                    return;
                }
                if (!finalClose) {
                    --readerData.semaphore;
                    if (trace) {
                        log.trace("Semaphore decreased to: {} for {}", (Object)readerData.semaphore, (Object)subReader);
                    }
                }
                if (readerData.semaphore < 0) {
                    log.error("Semaphore negative: {}", (Object)subReader.directory());
                }
                if (!isActive && readerData.semaphore == 0) {
                    this.searchIndexReaderSemaphores.remove(subReader);
                    closeReader = true;
                } else {
                    closeReader = false;
                }
            }
            finally {
                this.semaphoreIndexReaderLock.unlock();
            }
        }
        finally {
            directoryProviderLock.unlock();
        }
        if (closeReader) {
            if (trace) {
                log.trace("Closing IndexReader: {}", (Object)subReader);
            }
            try {
                subReader.close();
            }
            catch (IOException e) {
                log.warn("Unable to close Lucene IndexReader", (Throwable)e);
            }
        }
    }

    public void initialize(Properties props, SearchFactoryImplementor searchFactoryImplementor) {
        Set<DirectoryProvider<?>> providers = searchFactoryImplementor.getDirectoryProviders();
        this.perDirectoryProviderManipulationLocks = new HashMap<DirectoryProvider, Lock>(providers.size());
        for (DirectoryProvider<?> dp : providers) {
            this.perDirectoryProviderManipulationLocks.put(dp, new ReentrantLock());
        }
        this.perDirectoryProviderManipulationLocks = Collections.unmodifiableMap(this.perDirectoryProviderManipulationLocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        IndexReader[] readers;
        boolean trace = log.isTraceEnabled();
        this.semaphoreIndexReaderLock.lock();
        try {
            this.activeSearchIndexReaders.clear();
            readers = this.searchIndexReaderSemaphores.keySet().toArray(new IndexReader[this.searchIndexReaderSemaphores.size()]);
        }
        finally {
            this.semaphoreIndexReaderLock.unlock();
        }
        for (IndexReader reader : readers) {
            this.closeInternalReader(trace, reader, true);
        }
        if (this.searchIndexReaderSemaphores.size() != 0) {
            log.warn("ReaderProvider contains readers not properly closed at destroy time");
        }
    }

    private static class ReaderData {
        public int semaphore;
        public DirectoryProvider provider;

        public ReaderData(int semaphore, DirectoryProvider provider) {
            this.semaphore = semaphore;
            this.provider = provider;
        }
    }
}

