/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.registry.osgi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.spi.Registry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiRegistry
implements Registry {
    private Log logger = LogFactory.getLog(this.getClass());
    private final BundleContext bundleContext;

    public OSGiRegistry(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Object lookup(String name) {
        this.logger.debug((Object)"Looking up name {0}", new Object[]{name});
        return this.lookup(name, null);
    }

    public <T> T lookup(String name, Class<T> clazz) {
        this.logger.debug((Object)"Looking up name {0}, class {1}", new Object[]{name, clazz});
        return this.lookupByType(clazz).get(name);
    }

    public <T> Map<String, T> lookupByType(Class<T> clazz) {
        this.logger.debug((Object)"Looking up class {0}", new Object[]{clazz});
        if (this.bundleContext != null) {
            try {
                ServiceReference[] refs = this.bundleContext.getServiceReferences(null, null);
                if (refs != null && refs.length >= 0) {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    for (ServiceReference ref : refs) {
                        Object service;
                        String serviceName = (String)ref.getProperty("name");
                        if (serviceName == null || (service = this.bundleContext.getService(ref)) == null) continue;
                        this.logger.debug((Object)"\tChecking service named {0} with class {1} against class {2}", new Object[]{serviceName, service.getClass(), clazz});
                        if (clazz != null && !clazz.isAssignableFrom(service.getClass())) continue;
                        result.put(serviceName, service);
                    }
                    this.logger.debug((Object)"Looked up for class {0}, returning {1}", new Object[]{clazz, result});
                    return result;
                }
            }
            catch (InvalidSyntaxException e) {
                this.logger.error((Object)"Failed listing OSGi services", new Object[]{e});
            }
        }
        this.logger.debug((Object)"Looked up for class {0}, returning empty map", new Object[]{clazz});
        return Collections.EMPTY_MAP;
    }
}

