/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.Val;

public class Coalesce
extends Val {
    private final Val[] _val;

    Coalesce(Val[] val) {
        this._val = val;
    }

    protected Object eval(Object candidate, Object orig, StoreContext ctx, Object[] params) {
        for (int i = 0; i < this._val.length - 1; ++i) {
            Object o1 = this._val[i].eval(candidate, orig, ctx, params);
            if (o1 == null) continue;
            return o1;
        }
        return this._val[this._val.length - 1].eval(candidate, orig, ctx, params);
    }

    protected Object eval(Object candidate, StoreContext ctx, Object[] params) {
        for (int i = 0; i < this._val.length - 1; ++i) {
            Object o1 = this._val[i].eval(candidate, null, ctx, params);
            if (o1 == null) continue;
            return o1;
        }
        return this._val[this._val.length - 1].eval(candidate, null, ctx, params);
    }

    protected boolean compare(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    public Val[] getVal() {
        return this._val;
    }

    public Class getType() {
        Class<?> c1 = this._val[0].getType();
        for (int i = 1; i < this._val.length; ++i) {
            Class c2 = this._val[i].getType();
            c1 = Filters.promote(c1, c2);
        }
        return c1;
    }

    public void setImplicitType(Class type) {
    }

    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter(this);
        for (int i = 0; i < this._val.length; ++i) {
            this._val[i].acceptVisit(visitor);
        }
        visitor.exit(this);
    }
}

