/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.io;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBase;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxb.JAXBEncoderDecoder;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.MessagePartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataReaderImpl<T>
extends JAXBDataBase
implements DataReader<T> {
    private static final Logger LOG = LogUtils.getLogger(JAXBDataBinding.class);
    JAXBDataBinding databinding;
    boolean unwrapJAXBElement = true;
    ValidationEventHandler veventHandler;
    boolean setEventHandler = true;

    public DataReaderImpl(JAXBDataBinding binding, boolean unwrap) {
        super(binding.getContext());
        this.unwrapJAXBElement = unwrap;
        this.databinding = binding;
    }

    @Override
    public Object read(T input) {
        return this.read(null, input);
    }

    @Override
    public void setProperty(String prop, Object value) {
        if (prop.equals("unwrap.jaxb.element")) {
            this.unwrapJAXBElement = Boolean.TRUE.equals(value);
        } else if (prop.equals(Message.class.getName())) {
            Message m = (Message)value;
            this.veventHandler = (ValidationEventHandler)m.getContextualProperty("jaxb-validation-event-handler");
            if (this.veventHandler == null) {
                this.veventHandler = this.databinding.getValidationEventHandler();
            }
            this.setEventHandler = MessageUtils.getContextualBoolean(m, "set-jaxb-validation-event-handler", true);
        }
    }

    private Unmarshaller createUnmarshaller() {
        try {
            Unmarshaller um = null;
            um = this.context.createUnmarshaller();
            if (this.databinding.getUnmarshallerListener() != null) {
                um.setListener(this.databinding.getUnmarshallerListener());
            }
            if (this.setEventHandler) {
                um.setEventHandler(this.veventHandler);
            }
            if (this.databinding.getUnmarshallerProperties() != null) {
                for (Map.Entry<String, Object> propEntry : this.databinding.getUnmarshallerProperties().entrySet()) {
                    try {
                        um.setProperty(propEntry.getKey(), propEntry.getValue());
                    }
                    catch (PropertyException pe) {
                        LOG.log(Level.INFO, "PropertyException setting Marshaller properties", pe);
                    }
                }
            }
            um.setSchema(this.schema);
            um.setAttachmentUnmarshaller(this.getAttachmentUnmarshaller());
            return um;
        }
        catch (JAXBException ex) {
            if (ex instanceof UnmarshalException) {
                UnmarshalException unmarshalEx = (UnmarshalException)ex;
                throw new Fault(new org.apache.cxf.common.i18n.Message("UNMARSHAL_ERROR", LOG, unmarshalEx.getLinkedException().getMessage()), (Throwable)ex);
            }
            throw new Fault(new org.apache.cxf.common.i18n.Message("UNMARSHAL_ERROR", LOG, ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public Object read(MessagePartInfo part, T reader) {
        boolean honorJaxbAnnotation = false;
        if (part != null && part.getProperty("honor.jaxb.annotations") != null) {
            honorJaxbAnnotation = (Boolean)part.getProperty("honor.jaxb.annotations");
        }
        Annotation[] anns = null;
        if (honorJaxbAnnotation && (anns = this.getJAXBAnnotation(part)).length > 0) {
            QName qname = new QName(null, part.getConcreteName().getLocalPart());
            return JAXBEncoderDecoder.unmarshalWithBridge(qname, part.getTypeClass(), anns, this.databinding.getContextClasses(), reader, this.getAttachmentUnmarshaller());
        }
        if (part != null && part.getTypeClass() != null) {
            boolean useJAXBBridge = false;
            for (Field field : part.getTypeClass().getDeclaredFields()) {
                if (!field.getType().equals(XMLGregorianCalendar.class)) continue;
                useJAXBBridge = true;
                break;
            }
            if (useJAXBBridge) {
                return JAXBEncoderDecoder.unmarshalWithBridge(part.getConcreteName(), part.getTypeClass(), part.getTypeClass().getAnnotations(), this.databinding.getContextClasses(), reader, this.getAttachmentUnmarshaller());
            }
        }
        return JAXBEncoderDecoder.unmarshall(this.createUnmarshaller(), reader, part, this.unwrapJAXBElement);
    }

    @Override
    public Object read(QName name, T input, Class type) {
        return JAXBEncoderDecoder.unmarshall(this.createUnmarshaller(), input, name, type, this.unwrapJAXBElement);
    }
}

