/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.ow2.cmi.controller.server.DistributedObjectInfo;
import org.ow2.cmi.reference.CMIReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class ClusteredObjectView
implements Serializable {
    private static final long serialVersionUID = -607843632901577990L;
    private final Map<String, Set<CMIReference>> refs = new HashMap<String, Set<CMIReference>>();
    private DistributedObjectInfo objectInfo;

    public DistributedObjectInfo getObjectInfo() {
        return this.objectInfo;
    }

    public void setObjectInfo(DistributedObjectInfo objectInfo) {
        this.objectInfo = objectInfo;
    }

    public Set<CMIReference> getCMIReferences(String protocol) {
        try {
            return new HashSet<CMIReference>((Collection)this.refs.get(protocol));
        }
        catch (NullPointerException e) {
            return Collections.emptySet();
        }
    }

    public List<CMIReference> getCMIReferences() {
        ArrayList<CMIReference> cmiReferences = new ArrayList<CMIReference>();
        for (String protocol : this.refs.keySet()) {
            cmiReferences.addAll((Collection<CMIReference>)this.refs.get(protocol));
        }
        return cmiReferences;
    }

    public void addCMIReference(CMIReference cmiReference) {
        Set<CMIReference> cmiReferences = this.refs.get(cmiReference.getServerRef().getProtocol());
        if (cmiReferences == null) {
            cmiReferences = new HashSet<CMIReference>();
            this.refs.put(cmiReference.getServerRef().getProtocol(), cmiReferences);
        }
        cmiReferences.add(cmiReference);
    }

    public boolean removeCMIReference(CMIReference cmiReference) {
        Set<CMIReference> cmiReferences = this.refs.get(cmiReference.getServerRef().getProtocol());
        if (cmiReferences == null) {
            return false;
        }
        return cmiReferences.remove(cmiReference);
    }

    public void removeServerRef(String serverRef) {
        for (Set<CMIReference> cmiReferences : this.refs.values()) {
            Iterator<CMIReference> it = cmiReferences.iterator();
            while (it.hasNext()) {
                if (!it.next().getServerRef().getProviderURL().equals(serverRef)) continue;
                it.remove();
            }
        }
    }

    public String toString() {
        return "ClusteredObjectView[objectInfo=" + this.objectInfo + ", refs=" + this.refs.toString() + "]";
    }
}

