/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.Agent;
import fr.dyade.aaa.agent.AgentFactory;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.EngineMBean;
import fr.dyade.aaa.agent.EngineThread;
import fr.dyade.aaa.agent.ExceptionNotification;
import fr.dyade.aaa.agent.ExpiredNot;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.MessageConsumer;
import fr.dyade.aaa.agent.MessageQueue;
import fr.dyade.aaa.agent.MessageVector;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownAgent;
import fr.dyade.aaa.agent.UnknownAgentException;
import fr.dyade.aaa.common.Queue;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

class Engine
implements Runnable,
MessageConsumer,
EngineMBean {
    protected MessageQueue qin;
    protected volatile boolean isRunning;
    protected volatile boolean canStop;
    private int stamp;
    private byte[] stampBuf = null;
    private boolean modified = false;
    Hashtable agents;
    long now = 0L;
    int NbMaxAgents = 100;
    Vector fixedAgentIdList = null;
    Agent agent = null;
    Message msg = null;
    EngineThread thread = null;
    static final int RP_EXC_NOT = 0;
    static final int RP_EXIT = 1;
    static final String[] rpStrings = new String[]{"notification", "exit"};
    int recoveryPolicy = 0;
    private String name;
    protected Queue mq;
    protected Logger logmon = null;
    protected boolean needToBeCommited = false;
    protected long timeout = Long.MAX_VALUE;

    public long getNbReactions() {
        return this.now;
    }

    public int getNbMaxAgents() {
        return this.NbMaxAgents;
    }

    public void setNbMaxAgents(int NbMaxAgents) {
        this.NbMaxAgents = NbMaxAgents;
    }

    public int getNbAgents() {
        return this.agents.size();
    }

    public int getNbMessages() {
        return this.stamp;
    }

    public int getNbWaitingMessages() {
        return this.qin.size();
    }

    public int getNbFixedAgents() {
        return this.fixedAgentIdList.size();
    }

    public final String getName() {
        return this.name;
    }

    public final String getDomainName() {
        return "engine";
    }

    static Engine newInstance() throws Exception {
        String cname = "fr.dyade.aaa.agent.Engine";
        cname = AgentServer.getProperty("Engine", cname);
        Class<?> eclass = Class.forName(cname);
        return (Engine)eclass.newInstance();
    }

    final void push(AgentId from, AgentId to, Notification not) {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", push(" + from + ", " + to + ", " + not + ")"));
        }
        if (to == null || to.isNullId()) {
            return;
        }
        this.mq.push(Message.alloc(from, to, not));
    }

    final void dispatch() throws Exception {
        Message msg = null;
        while (!this.mq.isEmpty()) {
            try {
                msg = (Message)this.mq.get();
            }
            catch (InterruptedException exc) {
                continue;
            }
            if (msg.from == null) {
                msg.from = AgentId.localId;
            }
            Channel.post(msg);
            this.mq.pop();
        }
        Channel.save();
    }

    final void clean() {
        this.mq.clear();
    }

    protected Engine() throws Exception {
        this.name = "Engine#" + AgentServer.getServerId();
        this.logmon = Debug.getLogger("fr.dyade.aaa.agent.Engine.#" + AgentServer.getServerId());
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " created [" + this.getClass().getName() + "]."));
        }
        this.NbMaxAgents = AgentServer.getInteger("NbMaxAgents", this.NbMaxAgents);
        this.qin = new MessageVector(this.name, AgentServer.getTransaction().isPersistent());
        this.mq = new Queue();
        this.isRunning = false;
        this.canStop = false;
        this.thread = null;
        this.needToBeCommited = false;
        this.restore();
        if (this.modified) {
            this.save();
        }
    }

    void init() throws Exception {
        this.agents = new Hashtable();
        try {
            this.fixedAgentIdList = (Vector)AgentServer.getTransaction().load(this.getName() + ".fixed");
            if (this.fixedAgentIdList == null) {
                this.fixedAgentIdList = new Vector();
                AgentFactory factory = new AgentFactory(AgentId.factoryId);
                this.createAgent(AgentId.factoryId, factory);
                factory.save();
                this.logmon.log(BasicLevel.INFO, (Object)(this.getName() + ", factory created"));
            }
            int i = 0;
            while (i < this.fixedAgentIdList.size()) {
                try {
                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", loads fixed agent" + this.fixedAgentIdList.elementAt(i)));
                    }
                    this.load((AgentId)this.fixedAgentIdList.elementAt(i));
                    ++i;
                }
                catch (Exception exc) {
                    this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", can't restore fixed agent" + this.fixedAgentIdList.elementAt(i)), (Throwable)exc);
                    this.fixedAgentIdList.removeElementAt(i);
                }
            }
        }
        catch (IOException exc) {
            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", can't initialize"), (Throwable)exc);
            throw exc;
        }
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", initialized"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ends"));
        Agent[] ag = new Agent[this.agents.size()];
        int i = 0;
        Enumeration e = this.agents.elements();
        while (e.hasMoreElements()) {
            ag[i++] = (Agent)e.nextElement();
        }
        --i;
        while (i >= 0) {
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)("Agent" + ag[i].id + " [" + ag[i].name + "] garbaged"));
            }
            this.agents.remove(ag[i].id);
            try {
                this.agent = ag[i];
                ag[i].agentFinalize(false);
            }
            catch (Exception exc) {
                this.logmon.log(BasicLevel.ERROR, (Object)("Agent" + ag[i].id + " [" + ag[i].name + "] error during agentFinalize"), (Throwable)exc);
            }
            finally {
                this.agent = null;
            }
            ag[i] = null;
            --i;
        }
    }

    final void createAgent(AgentId id, Agent agent) throws Exception {
        agent.id = id;
        agent.deployed = true;
        agent.agentInitialize(true);
        this.createAgent(agent);
    }

    final void createAgent(Agent agent) throws Exception {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", creates: " + agent));
        }
        if (agent.isFixed()) {
            this.addFixedAgentId(agent.getId());
        }
        if (agent.logmon == null) {
            agent.logmon = Debug.getLogger("fr.dyade.aaa.agent.Agent.#" + AgentServer.getServerId());
        }
        agent.save();
        ++this.now;
        this.garbage();
        this.agents.put(agent.getId(), agent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteAgent(AgentId from) throws Exception {
        Agent ag;
        try {
            ag = this.load(from);
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", delete Agent" + ag.id + " [" + ag.name + "]"));
            }
            AgentServer.getTransaction().delete(ag.id.toString());
        }
        catch (UnknownAgentException exc) {
            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", can't delete unknown Agent" + from));
            throw new Exception("Can't delete unknown Agent" + from);
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", can't delete Agent" + from), (Throwable)exc);
            throw new Exception("Can't delete Agent" + from);
        }
        if (ag.isFixed()) {
            this.removeFixedAgentId(ag.id);
        }
        this.agents.remove(ag.getId());
        try {
            this.agent = ag;
            ag.agentFinalize(true);
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.ERROR, (Object)("Agent" + ag.id + " [" + ag.name + "] error during agentFinalize"), (Throwable)exc);
        }
        finally {
            this.agent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void garbage() {
        if (!AgentServer.getTransaction().isPersistent()) {
            return;
        }
        if (this.agents.size() < this.NbMaxAgents + this.fixedAgentIdList.size()) {
            return;
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", garbage: " + this.agents.size() + '/' + this.NbMaxAgents + '+' + this.fixedAgentIdList.size() + ' ' + this.now));
        }
        long deadline = this.now - (long)this.NbMaxAgents;
        Agent[] ag = new Agent[this.agents.size()];
        int i = 0;
        Enumeration e = this.agents.elements();
        while (e.hasMoreElements()) {
            ag[i++] = (Agent)e.nextElement();
        }
        --i;
        while (i >= 0) {
            if (ag[i].last <= deadline && !ag[i].fixed) {
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)("Agent" + ag[i].id + " [" + ag[i].name + "] garbaged"));
                }
                this.agents.remove(ag[i].id);
                try {
                    this.agent = ag[i];
                    ag[i].agentFinalize(false);
                }
                catch (Exception exc) {
                    this.logmon.log(BasicLevel.ERROR, (Object)("Agent" + ag[i].id + " [" + ag[i].name + "] error during agentFinalize"), (Throwable)exc);
                }
                finally {
                    this.agent = null;
                }
                ag[i] = null;
            }
            --i;
        }
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", garbage: " + this.agents.size()));
    }

    void removeFixedAgentId(AgentId id) throws IOException {
        this.fixedAgentIdList.removeElement(id);
        AgentServer.getTransaction().save(this.fixedAgentIdList, this.getName() + ".fixed");
    }

    void addFixedAgentId(AgentId id) throws IOException {
        this.fixedAgentIdList.addElement(id);
        AgentServer.getTransaction().save(this.fixedAgentIdList, this.getName() + ".fixed");
    }

    AgentId[] getLoadedAgentIdlist() {
        AgentId[] list = new AgentId[this.agents.size()];
        int i = 0;
        Enumeration e = this.agents.elements();
        while (e.hasMoreElements()) {
            list[i++] = ((Agent)e.nextElement()).id;
        }
        return list;
    }

    public String dumpAgent(String id) throws Exception {
        return this.dumpAgent(AgentId.fromString(id));
    }

    public String dumpAgent(AgentId id) throws IOException, ClassNotFoundException, Exception {
        Agent ag = (Agent)this.agents.get(id);
        if (ag == null && (ag = Agent.load(id)) == null) {
            return id.toString() + " unknown";
        }
        return ag.toString();
    }

    final Agent load(AgentId id) throws IOException, ClassNotFoundException, Exception {
        ++this.now;
        Agent ag = (Agent)this.agents.get(id);
        if (ag == null) {
            ag = this.reload(id);
            this.garbage();
        }
        ag.last = this.now;
        return ag;
    }

    final Agent reload(AgentId id) throws IOException, ClassNotFoundException, Exception {
        Agent ag = null;
        ag = Agent.load(id);
        if (ag != null) {
            try {
                this.agent = ag;
                ag.agentInitialize(false);
            }
            catch (Throwable exc) {
                this.agent = null;
                this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + "Can't initialize Agent" + ag.id + " [" + ag.name + "]"), exc);
                throw new Exception(this.getName() + "Can't initialize Agent" + ag.id);
            }
            if (ag.logmon == null) {
                ag.logmon = Debug.getLogger("fr.dyade.aaa.agent.Agent.#" + AgentServer.getServerId());
            }
            this.agents.put(ag.id, ag);
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + "Agent" + ag.id + " [" + ag.name + "] loaded"));
            }
        } else {
            throw new UnknownAgentException();
        }
        return ag;
    }

    public void insert(Message msg) {
        this.qin.insert(msg);
    }

    public void validate() {
        this.qin.validate();
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.thread = new EngineThread(this);
        this.thread.setDaemon(false);
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " starting."));
        String rp = AgentServer.getProperty("Engine.recoveryPolicy");
        if (rp != null) {
            int i = rpStrings.length;
            while (i-- > 0) {
                if (!rp.equals(rpStrings[i])) continue;
                this.recoveryPolicy = i;
                break;
            }
        }
        this.isRunning = true;
        this.canStop = true;
        this.thread.start();
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " started."));
    }

    public void stop() {
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", stops."));
        this.isRunning = false;
        if (this.thread != null) {
            while (this.thread.isAlive()) {
                if (this.canStop && this.thread.isAlive()) {
                    this.thread.interrupt();
                }
                try {
                    this.thread.join(1000L);
                }
                catch (InterruptedException exc) {}
            }
            this.thread = null;
        }
    }

    public MessageQueue getQueue() {
        return this.qin;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void save() throws IOException {
        if (this.modified) {
            this.stampBuf[0] = (byte)(this.stamp >>> 24 & 0xFF);
            this.stampBuf[1] = (byte)(this.stamp >>> 16 & 0xFF);
            this.stampBuf[2] = (byte)(this.stamp >>> 8 & 0xFF);
            this.stampBuf[3] = (byte)(this.stamp & 0xFF);
            AgentServer.getTransaction().saveByteArray(this.stampBuf, this.getName());
            this.modified = false;
        }
    }

    public void restore() throws Exception {
        this.stampBuf = AgentServer.getTransaction().loadByteArray(this.getName());
        if (this.stampBuf == null) {
            this.stamp = 0;
            this.stampBuf = new byte[4];
            this.modified = true;
        } else {
            this.stamp = ((this.stampBuf[0] & 0xFF) << 24) + ((this.stampBuf[1] & 0xFF) << 16) + ((this.stampBuf[2] & 0xFF) << 8) + (this.stampBuf[3] & 0xFF);
            this.modified = false;
        }
    }

    public void delete() throws IllegalStateException {
        throw new IllegalStateException();
    }

    protected final int getStamp() {
        return this.stamp;
    }

    protected final void setStamp(int stamp) {
        this.modified = true;
        this.stamp = stamp;
    }

    protected final void stamp(Message msg) {
        this.modified = true;
        msg.source = AgentServer.getServerId();
        msg.dest = AgentServer.getServerId();
        msg.stamp = ++this.stamp;
    }

    public void post(Message msg) throws Exception {
        if (msg.isPersistent()) {
            this.stamp(msg);
            msg.save();
        }
        this.qin.push(msg);
    }

    protected void onTimeOut() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            block15: while (this.isRunning) {
                block27: {
                    this.agent = null;
                    this.canStop = true;
                    try {
                        this.msg = this.qin.get(this.timeout);
                        if (this.msg == null) {
                            this.onTimeOut();
                        }
                    }
                    catch (InterruptedException exc) {}
                    continue;
                    this.canStop = false;
                    if (!this.isRunning) {
                        break;
                    }
                    if (this.msg.from == null || this.msg.to == null || this.msg.not == null) {
                        this.logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + ": Bad message [" + this.msg.from + ", " + this.msg.to + ", " + this.msg.not + ']'));
                        this.qin.pop();
                        this.msg.delete();
                        this.msg.free();
                        continue;
                    }
                    if (this.msg.not.expiration <= 0L || this.msg.not.expiration >= System.currentTimeMillis()) {
                        try {
                            this.agent = this.load(this.msg.to);
                            break block27;
                        }
                        catch (UnknownAgentException exc) {
                            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ": Unknown agent, " + this.msg.to + ".react(" + this.msg.from + ", " + this.msg.not + ")"));
                            this.agent = null;
                            this.push(AgentId.localId, this.msg.from, new UnknownAgent(this.msg.to, this.msg.not));
                            break block27;
                        }
                        catch (Exception exc) {
                            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ": Can't load agent, " + this.msg.to + ".react(" + this.msg.from + ", " + this.msg.not + ")"), (Throwable)exc);
                            this.agent = null;
                            AgentServer.stop(false);
                            break;
                        }
                    }
                    if (this.msg.not.deadNotificationAgentId != null) {
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ": forward expired notification " + this.msg.from + ", " + this.msg.not + " to " + this.msg.not.deadNotificationAgentId));
                        }
                        ExpiredNot expiredNot = new ExpiredNot(this.msg.not, this.msg.from, this.msg.to);
                        this.push(AgentId.localId, this.msg.not.deadNotificationAgentId, expiredNot);
                    } else if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ": removes expired notification " + this.msg.from + ", " + this.msg.not));
                    }
                }
                if (this.agent != null) {
                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ": " + this.agent + ".react(" + this.msg.from + ", " + this.msg.not + ")"));
                    }
                    try {
                        this.agent.react(this.msg.from, this.msg.not);
                    }
                    catch (Exception exc) {
                        this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ": Uncaught exception during react, " + this.agent + ".react(" + this.msg.from + ", " + this.msg.not + ")"), (Throwable)exc);
                        switch (this.recoveryPolicy) {
                            default: {
                                this.abort(exc);
                                continue block15;
                            }
                            case 1: 
                        }
                        AgentServer.stop(false);
                        break;
                    }
                }
                this.commit();
            }
        }
        catch (Throwable exc) {
            this.logmon.log(BasicLevel.FATAL, (Object)(this.getName() + ": Fatal error"), exc);
            this.canStop = false;
            AgentServer.stop(false);
        }
        finally {
            this.terminate();
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " stopped."));
        }
    }

    void commit() throws Exception {
        AgentServer.getTransaction().begin();
        this.qin.pop();
        this.msg.delete();
        this.msg.free();
        this.dispatch();
        if (this.agent != null) {
            this.agent.save();
        }
        AgentServer.getTransaction().commit(false);
        Channel.validate();
        AgentServer.getTransaction().release();
    }

    void abort(Exception exc) throws Exception {
        AgentServer.getTransaction().begin();
        try {
            this.agent = this.reload(this.msg.to);
        }
        catch (Exception exc2) {
            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", can't reload Agent" + this.msg.to), (Throwable)exc2);
            throw new Exception("Can't reload Agent" + this.msg.to);
        }
        this.qin.pop();
        this.msg.delete();
        this.msg.free();
        this.clean();
        this.push(AgentId.localId, this.msg.from, new ExceptionNotification(this.msg.to, this.msg.not, exc));
        this.dispatch();
        AgentServer.getTransaction().commit(false);
        Channel.validate();
        AgentServer.getTransaction().release();
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append('(').append(super.toString());
        strbuf.append(",name=").append(this.getName());
        strbuf.append(",running=").append(this.isRunning());
        strbuf.append(",agent=").append(this.agent).append(')');
        return strbuf.toString();
    }
}

